% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx.R
\name{approx}
\alias{approx}
\alias{approx_laplace}
\alias{approx_ep}
\title{Approximations to the posterior of the latent values}
\usage{
approx_laplace(maxiter = 30, tol = 1e-04)

approx_ep(damping = 0.9, quad_order = 11, maxiter = 100)
}
\arguments{
\item{maxiter}{Maximum number of iterations in the Laplace/EP iteration.}

\item{tol}{Convergence tolerance.}

\item{damping}{Damping factor for EP. Should be between 0 and 1. Smaller values
typically lead to more stable iterations, but also increase the number of iterations,
and thus make the algorithm slower.}

\item{quad_order}{Order of the Gauss-Hermite quadrature used to evaluate the required
tilted moments in EP.}
}
\value{
The approximation object.
}
\description{
Functions for initializing the approximation for the latent values, which can
then be passed to \code{\link{gp_init}}.
The supported methods are:
\describe{
 \item{\code{approx_laplace}}{ Laplace's method, that is, based on local second
  order approximation to the log likelihood. For Gaussian likelihood, this means exact inference
   (no approximation). }
 \item{\code{approx_ep}}{ Expectation propagation, EP. Approximates the likelihood by
  introducing Gaussian pseudo-data so that the posterior marginals match to the so called
   tilted distributions (leave-one-out posterior times the true likelihood factor) as
    closely as possible.  Typically more accurate than
  Laplace, but slower. }
}
}
\section{References}{


Rasmussen, C. E. and Williams, C. K. I. (2006). Gaussian processes for machine learning.
MIT Press.
}

\examples{

# Basic usage
gp <- gp_init(
  cfs = cf_sexp(),
  lik = lik_bernoulli(),
  method = method_fitc(num_inducing = 100),
  approx = approx_ep()
)

}
