% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gplsim.r
\name{gplsim}
\alias{gplsim}
\alias{gplsim.default}
\alias{gplsim.formula}
\title{Function to fit generalized partially linear single-index models via penalized splines}
\usage{
gplsim(...)

\method{gplsim}{default}(
  Y = Y,
  X = X,
  Z = Z,
  family = gaussian(),
  penalty = TRUE,
  profile = TRUE,
  user.init = NULL,
  bs = "ps",
  ...
)

\method{gplsim}{formula}(
  formula,
  data,
  family = gaussian(),
  penalty = TRUE,
  profile = TRUE,
  user.init = NULL,
  bs = "ps",
  ...
)
}
\arguments{
\item{...}{includes optional arguments user can pass to \code{mgcv::gam} or \code{glm}, such as \code{k}, which is the dimension of the basis of the smooth term and \code{m}, which is the order of the penalty for the smooth term. Others include:
\code{scale} The optional argument scale is a numeric indicator with a default value set to -1. Any negative value including -1 indicates that the scale of response distribution is unknown, thus need to be estimated. Another option is 0 signaling scale of 1 for Poisson and binomial distribution and unknown for others. Any positive value will be taken as the known scale parameter.
\code{smooth_selection} The optional argument smooth_selection is another character variable that specifies the criterion used in the selection of a smoothing parameter. The supported criteria include "GCV.Cp","GACV.Cp", "ML","P-ML", "P-REML" and "REML", while the default criterion is "GCV.Cp".}

\item{Y}{Response variable, should be a vector.}

\item{X}{Single index covariates.}

\item{Z}{Partially linear covariates.}

\item{family}{A \code{family} object: a list of functions and expressions
for defining \code{link} and \code{variance} functions.
Families supported are \code{binomial}, \code{gaussian}.
The default family is \code{gaussian}.}

\item{penalty}{Whether use penalized splines or un-penalized splines to fit the model. The default is TRUE.}

\item{profile}{profile is a logical variable that indicates whether the algorithm with profile likelihood or algorithm with NLS procedure should be used. The default algorithm is set to algorithm with profile likelihood.}

\item{user.init}{The user.init is a numeric vector of the same length as the dimensionality of single index predictors. The users can use this argument to pass in any appropriate user-defined initial single-index coefficients based on prior information or domain knowledge. The default value is NULL.}

\item{bs}{bs is a character variable that specifies the spline basis in the estimation of unknown univariate function of single index. Default is P-splines.}

\item{formula}{A model formula;}

\item{data}{A data matrix containing the variables in the formula.}
}
\value{
theta  Estimation of Theta

coefficients  the coefficients of the fitted model. Parametric coefficients are first, followed by coefficients for each spline term in turn.

... See GAM object

theta  Estimation of Theta

coefficients  the coefficients of the fitted model. Parametric coefficients are first, followed by coefficients for each spline term in turn.

... See GAM object
}
\description{
This function employs penalized spline (P-spline) to estimate generalized
partially linear single index models, which extend the generalized linear
models to include nonlinear effect for some predictors.

This function add formula interface to gplsim function
}
\details{
For formula method, see ?gplsim.formula
}
\examples{
# parameter settings
n=200
true.theta = c(1, 1, 1)/sqrt(3)
# Gaussian case
# This function generate a plain sin bump model with gaussian response.
data <- generate_data(n,true.theta=true.theta,family="gaussian")
y=data$Y       # continous response
X=data$X       # single index term ;
Z=data$Z       # partially linear term ;

result <- gplsim(y,X,Z,family = gaussian)
result$theta
result$coefficients
summary(result)


#plot the estimated single index function curve
plot_si(result)
}
