% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_xy_Group.R
\name{plot_xy_Group}
\alias{plot_xy_Group}
\title{Plot points on a quantitative X - Y plot & a grouping variable.}
\usage{
plot_xy_Group(
  data,
  xcol,
  ycol,
  Group,
  facet,
  ErrorType = c("none", "SD", "SEM", "CI95", "Boxplot"),
  SmoothType = c("none", "Loess", "Linear"),
  symsize = 3,
  s_alpha,
  TextXAngle = 0,
  mean_size,
  m_alpha = 1,
  LogYTrans,
  LogXTrans,
  LogYBreaks = waiver(),
  LogXBreaks = waiver(),
  LogYLabels = waiver(),
  LogXLabels = waiver(),
  LogYLimits = NULL,
  LogXLimits = NULL,
  facet_scales = "fixed",
  fontsize = 20,
  bwid = 0.3,
  b_alpha = 0.3,
  l_alpha = 0.8,
  sm_alpha = 0.3,
  symthick,
  bthick,
  ewid = 0.1,
  e_alpha = 1,
  ColPal = NULL,
  ColSeq = TRUE,
  ColRev = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame containing the variables to be plotted.}

\item{xcol}{A column name in \code{data} for the x-axis (typically a factor or grouping variable).}

\item{ycol}{A column name in \code{data} for the y-axis (numeric).}

\item{Group}{A grouping variable used for colour/fill aesthetics. Whether this variable is numeric or not will determine colour palette choice for the \code{ColPal} argument.}

\item{facet}{An optional variable for faceting the plot using \code{facet_wrap()}.}

\item{ErrorType}{select the way to show data centrality and dispersion. The default is "none", which can be changed to "SD" (standard deviation), "SEM" (standard error of the mean) or "CI95" (95\% confidence interval based on \emph{t} distributions); all these will be displayed with a square symbol representing the mean. Choosing \code{Boxplot} will show a box and whiskers plot and the median. A line joining the central values will also appear. Use \code{l_alpha = 0} to not show the line.}

\item{SmoothType}{Add a smoothened average using 'Loess' or 'Linear', which will be passed on to \code{stat_smooth} as \code{method = "loess"} or \code{method = "lm"}, respectively.}

\item{symsize}{Size of the raw data points. Default is \code{3}.}

\item{s_alpha}{Alpha transparency for raw data points. Default is \code{0.8}, which will reduce to \code{0.2} when an \code{ErrorType} is set.}

\item{TextXAngle}{Angle of x-axis text labels. Default is \code{0}.}

\item{mean_size}{Size of the square symbol representing the mean. Default is \code{symsize + 3} to prominently show the central value.}

\item{m_alpha}{Alpha transparency for the mean symbol. Default is \code{1}.}

\item{LogYTrans}{transform Y axis into "log10" or "log2" (in quotes).}

\item{LogXTrans}{transform X axis into "log10" or "log2"}

\item{LogYBreaks}{argument for \code{ggplot2[scale_y_continuous]} for Y axis breaks on log scales, default is \code{waiver()}, or provide a vector of desired breaks.}

\item{LogXBreaks}{argument for \code{ggplot2[scale_x_continuous]} for Y axis breaks on log scales, default is \code{waiver()}, or provide a vector of desired breaks.}

\item{LogYLabels}{argument for \code{ggplot2[scale_y_continuous]} for Y axis labels on log scales, default is \code{waiver()}, or provide a vector of desired labels.}

\item{LogXLabels}{argument for \code{ggplot2[scale_x_continuous]} for Y axis labels on log scales, default is \code{waiver()}, or provide a vector of desired labels.}

\item{LogYLimits}{a vector of length two specifying the range (minimum and maximum) of the Y axis.}

\item{LogXLimits}{a vector of length two specifying the range (minimum and maximum) of the X axis.}

\item{facet_scales}{whether or not to fix scales on X & Y axes for all graphs. Can be \code{fixed} (default), \code{free}, \code{free_y} or \code{free_x} (for Y and X axis one at a time, respectively).}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{\link[ggplot2]{theme_classic}}, default set to size 20.}

\item{bwid}{width of boxplot (default = 0.3).}

\item{b_alpha}{fractional opacity of boxes (default = 0.3).}

\item{l_alpha}{fractional opacity of lines joining boxes, (default = 0.8).}

\item{sm_alpha}{fractional opacity of error range around loess or linear smooth fit (default = 0.3).}

\item{symthick}{size (in 'pt' units) of outline of symbol lines (\code{stroke}), default = \code{fontsize}/22.}

\item{bthick}{size (in 'pt' units) of outline of boxes, whisker and joining lines (\code{stroke}), default = \code{fontsize}/22.}

\item{ewid}{width of errorbars (default = 0.1).}

\item{e_alpha}{fractional opacity of error bars (default = 1).}

\item{ColPal}{Character. Name of the colour palette to use from grafify. For categorical variables, one of: \code{"okabe_ito"}, \code{"all_grafify"}, \code{"bright"}, \code{"contrast"}, \code{"dark"}, \code{"fishy"}, \code{"kelly"}, \code{"light"}, \code{"muted"}, \code{"pale"}, \code{"r4"}, \code{"safe"}, \code{"vibrant"}. For quantitative variables, one of: \code{blue_conti}, \code{yellow_conti}, \code{grey_conti}, \code{PrGn_div}, \code{PrGn_div}.}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour within the selected palette, default F (FALSE); can be set to T (TRUE).}

\item{...}{Additional arguments passed to \code{ggplot2} geoms or scales.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a data table, quantitative X and Y variables along with a grouping variable that is either categorical or numeric. The colour of data symbols is mapped to the grouping variable. This function is related to  \code{\link{plot_xy_CatGroup}}  and \code{\link{plot_xy_NumGroup}}, and could eventually replace them in future updates.

Central value and scatter can be shown by choosing the \code{ErrorType} argument. Mean and error bars (SD, SEM or CI95) or box and whisker plot options are available.
}
\details{
When \code{ErrorType} is set to a value other than \code{none}, a line joining the central value (mean or median, respectively) will also appear (set \code{l_alpha = 0} if this is not desired). Other options for \code{ErrorType} are: \code{SD}, \code{SEM}, \code{CI95}, \code{Boxplot}.

When \code{SD}/\code{SEM}/\code{CI95} are chosen, the mean value will appear as a larger square symbol. Its opacity and size can be adjusted with \code{m_alpha} and \code{mean_size}, respectively.

The smooth fitted line type can be shown with the \code{SmoothType} argument, which can take the following options: \code{none}, \code{Linear} or \code{Loess}. Latter two options are fitted using \code{\link[ggplot2]{stat_smooth}} with \code{lm} or \code{loess} options, respectively.

Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} (logical TRUE/FALSE) decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.
}
\examples{
#The grouping factor cyl  is automatically converted to categorical variable
plot_xy_Group(data = mpg,
xcol = cyl, ycol = cty, Group = drv,
ErrorType = "SD")

#with a Linear smooth line
plot_xy_Group(data = mpg,
xcol = cyl, ycol = cty, Group = drv,
ErrorType = "SD", SmoothType = "Linear")
 
}
