% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffexp.R
\name{GetPairContrasts}
\alias{GetPairContrasts}
\title{Create a contrast matrix for two given conditions}
\usage{
GetPairContrasts(d, name, A, B)
}
\arguments{
\item{d}{A grandR object or a column annotation table}

\item{name}{the name of the contrast}

\item{A}{definition of the condition of interest, see details}

\item{B}{definition of the reference condition , see details}
}
\value{
A data frame with a single column representig a contrast matrix to be used in \code{\link{ApplyContrasts}}, \code{\link{LFC}}, \code{\link{PairwiseDESeq2}}
}
\description{
Each column of a contrast matrix represents a pairwise comparison of all samples or cells of
a grandR object (or a column annotation table). Elements being 1 are contrasted vs. elements being -1
(and all 0 are irrelevant for this comparison).
}
\details{
This creates a contrast A vs B (i.e. the fold change would be A/B)

Columns that belong to A or B can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment having the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition="x").
}
\seealso{
\code{\link{ApplyContrasts}}, \code{\link{LFC}}, \code{\link{PairwiseDESeq2}}, \code{\link{GetContrasts}}
}
\concept{diffexp}
