% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat_pw_fst.R
\name{mat_pw_fst}
\alias{mat_pw_fst}
\title{Compute a pairwise FST matrix between populations}
\usage{
mat_pw_fst(x)
}
\arguments{
\item{x}{An object of class \code{genind}}
}
\value{
A pairwise \code{matrix} of FST with as many rows and columns as
there are populations in the input data.
}
\description{
The function computes the pairwise FST matrix between
populations from an object of class \code{genind}
}
\details{
The formula used is that of Weir et Cockerham (1984).
This functions uses directly the function \code{pairwise.WCfst}
from \pkg{hierfstat}.
}
\section{Warnings}{

Negative values are converted into 0
}

\examples{
\dontrun{
data("data_ex_genind")
mat_fst <- mat_pw_fst(data_ex_genind)
}
}
\references{
\insertRef{weir1984estimating}{graph4lg}
}
\author{
P. Savary
}
\keyword{internal}
