% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchBlocks.R
\name{sbmNorm}
\alias{sbmNorm}
\title{(squared) norm between two stochastic block models}
\usage{
sbmNorm(theta1, theta2)
}
\arguments{
\item{theta1}{a stochastic block model parameter}

\item{theta2}{a stochastic block model parameter}
}
\value{
(squared) norm between two stochastic block models
}
\description{
the norm is the minimal graphon distance between two stochastic block model
parameters obtained with the best permutations of the parameters
}
\examples{
theta1 <- list(pi=c(.5,.5), gamma=matrix((1:4)/8,2,2))
theta2 <- list(pi=c(.5,.5), gamma=matrix(4:1/8,2,2))
theta3 <- list(pi=c(.5,.5), gamma=matrix(1:4/4,2,2))
sbmNorm(theta1, theta2)
sbmNorm(theta1, theta3)
sbmNorm(theta2, theta3)
}
