% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addEdges.R
\name{addEdges}
\alias{addEdges}
\title{Add edges to graph.}
\usage{
addEdges(graph, generator, type = "all", k = NULL, cluster.ids = NULL,
  ...)
}
\arguments{
\item{graph}{[\code{\link{grapherator}}]\cr
Graph.}

\item{generator}{[\code{function(graph, ...)}]\cr
Method applied to \code{graph} in order to determine which edges to add.}

\item{type}{[\code{character(1)}]\cr
Value \dQuote{all} applies \code{generator} to all nodes. Value \dQuote{intracluster}
instead applies the method for each cluster seperately. Value \dQuote{intercluster}
selects each \code{k} nodes from each cluster and applies \code{generator} to the union.
Lastly, value \dQuote{intercenter} selects the cluster centers exclusively.
Default is \dQuote{all}.}

\item{k}{[\code{integer} | \code{NULL}]\cr
Integer vector specifying the number of nodes selected randomly from each cluster
to be selected for edge construction. May be a scalar value or a vector of length
\code{graph$n.clusters}. NAs are allowed and indicate clusters to be ignored.}

\item{cluster.ids}{[\code{integer} | \code{NULL}]\cr
Ignored unless \code{type} is not set to \dQuote{intracluster}.
Integer vector of cluster IDs. If \code{NULL} the \code{generator} is applied
within each cluster.}

\item{...}{[any]\cr
Further arguments passed down to edge generator \code{generator}.}
}
\value{
[\code{\link{grapherator}}] Graph.
}
\description{
This method allows to add edges to a \code{grapherator} graph.
The method can be applied multiple times with different parameterizations. E.g.,
add edges in clusters first and add edges between clusters in a second step.
}
\examples{
g = graph(0, 1000)
g = addNodes(g, n = 5, generator = addNodesLHS)
g = addNodes(g, n = c(3, 10, 20, 10, 40), by.centers = TRUE, generator = addNodesUniform,
  lower = c(0, 0), upper = c(30, 30))
# user different edge generators for clusters
g = addEdges(g, generator = addEdgesDelauney, type = "intracluster", cluster.ids = 1:3)
g = addEdges(g, generator = addEdgesSpanningTree, type = "intracluster", cluster.ids = 4:5)
# link cluster centers
g = addEdges(g, generator = addEdgesSpanningTree, runs = 2, type = "intercenter")
# additional random links between each 2 nodes from each cluster
g = addEdges(g, generator = addEdgesGilbert, p = 0.4, type = "intercluster", k = 2)
}
\references{
Erdos, P., and A. Renyi. 1959. "On random graphs, I." Publicationes Mathematicae
(Debrecen) 6: 290-97.

Waxman, B. M. 1988. "Routing of Multipoint Connections."" IEEE Journal on Selected
Areas in Communications 6 (9): 1617-22. doi:10.1109/49.12889.

Knowles, J. D., and D. W. Corne. 2001. "Benchmark Problem Generators and Results
for the Multiobjective Degree-Constrained Minimum Spanning Tree Problem."
In Proceedings of the 3rd Annual Conference on Genetic and Evolutionary
Computation, 424-31. GECCO'01. San Francisco, CA, USA: Morgan Kaufmann Publishers Inc.
}
\seealso{
Other graph generators: \code{\link{addNodes}},
  \code{\link{addWeights}}, \code{\link{graph}}
}
