% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{graph}
\alias{graph}
\title{Generate a bare graph.}
\usage{
graph(lower, upper)
}
\arguments{
\item{lower}{[\code{integer(1)}]\cr
Lower bounds for node coordinates in the Euclidean plane.}

\item{upper}{[\code{integer(1)}]\cr
Upper bounds for node coordinates in the Euclidean plane.}
}
\value{
[\code{\link{grapherator}}] Graph.
}
\description{
This function generates a bare graph object of type \code{\link{grapherator}}.
The generated object does not contain nodes, edges or edge weights. It serves as a starting
point for a three step approach of grapherator graph construction:
1) Add nodes respectively coordinates via \code{\link{addNodes}}, 2) add edges
via \code{\link{addEdges}} and finally 3) add edge weights with the function
\code{\link{addWeights}}.
}
\examples{
# complete graph with one U(10, 20) sampled weight per edge
g = graph(0, 10)
g = addNodes(g, n = 10, generator = addNodesUniform)
g = addEdges(g, generator = addEdgesComplete)
g = addWeights(g, generator = addWeightsRandom, method = runif, min = 10, max = 20)
\dontrun{
do.call(gridExtra::grid.arrange, plot(g, show.edges = FALSE))
}

# we extend the graph by adding another weight which is based
# on the Euclidean distance between the node coordinates
g = addWeights(g, generator = addWeightsDistance, method = "euclidean")
\dontrun{
do.call(gridExtra::grid.arrange, plot(g, show.edges = FALSE))
}

# next we generate a graph with each two weights per edge which resembles
# a street network. The edge weights have a positive correlation.
g = graph(0, 100)
g = addNodes(g, n = 5, generator = addNodesLHS)
g = addNodes(g, n = c(10, 10, 15, 20, 50), by.centers = TRUE,
  generator = addNodesUniform, lower = c(0, 0), upper = c(10, 10))
g = addEdges(g, generator = addEdgesDelauney, type = "intracluster")
g = addEdges(g, generator = addEdgesDelauney, type = "intercluster", k = 4L)
g = addWeights(g, generator = addWeightsCorrelated, rho = 0.6)
\dontrun{
print(g)
do.call(gridExtra::grid.arrange, plot(g, show.edges = FALSE))
}
}
\seealso{
Other graph generators: \code{\link{addEdges}},
  \code{\link{addNodes}}, \code{\link{addWeights}}
}
