% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grapherator-package.R
\docType{package}
\name{grapherator-package}
\alias{grapherator-package}
\title{grapherator: A modular multi-step graph generator}
\description{
Due to lack of real world graphs, e.g., the optimization community often
relies on artificial graphs to benchmark algorithms. The \pkg{grapherator}
package implements a multi-step approach for the generation of weighted graphs.
A set of predefined node, edge and weight generators allows for fast and convenient
graph generation. Furthermore, the modular structure of the package enables
writing user-defined generators and use them within the framework in a
plug-and-play style.
}
\section{Generation philosophy}{

The graph generation follows a three step procedure. A bare graph (see \code{\link{graph}}), i.e., an empty graph object, the following three
serves as a staring point for several iterations of the following steps. Note that
once edges have been added, no furhter nodes may be added. Likewise, after weights
have been attached to edges, no further edges may be added.
1) Node generation via \code{\link{addNodes}}: nodes are generated by placing node
coordinates in the two-dimensional Euclidean plane using different node generators.
2) Edge generation via \code{\link{addEdges}}: links between nodes are established
via one or multiple edge generators.
3) Weight generation via \code{\link{addWeights}}: One or more weights are attached
to each edge by different weight generators.
}

