% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_packages.R
\name{scan_packages}
\alias{scan_packages}
\title{Scan a project or folder for packages used}
\usage{
scan_packages(
  pkgs = "All",
  omit = c("grateful"),
  cite.tidyverse = TRUE,
  dependencies = FALSE,
  desc.path = NULL,
  skip.missing = FALSE,
  ...
)
}
\arguments{
\item{pkgs}{Character. Either "All" to include all packages used in scripts
within the project/folder (the default), "Session" to include only packages
used in the current session, or the path to an R script (including \code{.R} extension),
'Rmarkdown' (\code{.Rmd}) or 'Quarto' document (\code{qmd}) to scan only the packages used
in that single script or document.
Alternatively, \code{pkgs} can also be a character vector of package names to
get citations for. To cite R as well as the given packages,
include "base" in \code{pkgs} (see examples).
Finally, \code{pkgs} can be a character vector of \code{Depends}, \code{Imports}, \code{Suggests},
\code{LinkingTo} and their combination, to obtain the dependencies of an R package
as stated in its DESCRIPTION file (see \code{desc.path}).
Note that in this case, package versions will
be 'NA' unless required versions are stated in the DESCRIPTION file
(e.g. 'testthat (>= 3.0.0)'), and package citations will use the information
from installed versions of those packages in the user computer.}

\item{omit}{Character vector of package names to be omitted from the citation
report. \code{grateful} is omitted by default. Use \code{omit = NULL} to include all
packages.}

\item{cite.tidyverse}{Logical. If \code{TRUE}, all tidyverse packages
(dplyr, ggplot2, etc) will be collapsed into a single citation
of the 'tidyverse', as recommended by the tidyverse team.}

\item{dependencies}{Logical. Include the dependencies of your used packages?
If \code{TRUE}, will include all the packages that your used packages depend on.}

\item{desc.path}{Optional. Path to the package DESCRIPTION file from which to
parse the package dependencies (see \code{pkgs}).
If NULL, will default to the working directory.}

\item{skip.missing}{Logical. If FALSE (the default), will return an error if
some package(s) are used somewhere in the project but they are not currently
installed. If TRUE, will skip those missing packages, issuing a warning. Note
such packages will thus not be included in the citation list, even though they
might have been used in the project.}

\item{...}{Other parameters passed to \code{\link[renv:dependencies]{renv::dependencies()}}.}
}
\value{
a data.frame with package names and versions
}
\description{
Scan a project or folder for packages used
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
scan_packages()
scan_packages(pkgs = "Session")
scan_packages(pkgs = c("renv", "remotes", "knitr"))
\dontshow{\}) # examplesIf}
}
