% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difference-smooths.R
\name{difference_smooths}
\alias{difference_smooths}
\alias{difference_smooths.gam}
\title{Differences of factor smooth interactions}
\usage{
difference_smooths(model, ...)

\method{difference_smooths}{gam}(
  model,
  select = NULL,
  smooth = deprecated(),
  n = 100,
  ci_level = 0.95,
  data = NULL,
  group_means = FALSE,
  partial_match = TRUE,
  unconditional = FALSE,
  frequentist = FALSE,
  ...
)
}
\arguments{
\item{model}{A fitted model.}

\item{...}{arguments passed to other methods. Not currently used.}

\item{select}{character, logical, or numeric; which smooths to compare. If
\code{NULL}, the default, then all model smooths are factor-smooth interactions
are compared. Numeric \code{select} indexes the smooths in the order they are
specified in the formula and stored in \code{object}. Character \code{select} matches
the labels for smooths as shown for example in the output from
\code{summary(object)}. Logical \code{select} operates as per numeric \code{select} in the
order that smooths are stored. Careful selection is needed because it is
not allowed to compare smooths of different covariates or of different
factor-by variables.

For character \code{select}, specific named smooths cane be provided, in which
case, the exact names of the smooths (as given by \code{\link[=smooths]{smooths()}}, for example,
can be specified, and \code{partial_match} must be set to \code{FALSE}.}

\item{smooth}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{select} instead.}

\item{n}{numeric; the number of points at which to evaluate the difference
between pairs of smooths.}

\item{ci_level}{numeric between 0 and 1; the coverage of credible interval.}

\item{data}{data frame of locations at which to evaluate the difference
between smooths.}

\item{group_means}{logical; should the group means be included in the
difference?}

\item{partial_match}{logical; should \code{smooth} match partially against
\code{smooths}? If \code{partial_match = TRUE}, \code{smooth} must only be a single
string, a character vector of length 1. Unlike similar functions, the
default here is \code{TRUE} because the intention is that users will be matching
against factor-by smooth labels.}

\item{unconditional}{logical; account for smoothness selection in the model?}

\item{frequentist}{logical; use the frequentist covariance matrix?}
}
\description{
Estimates pairwise differences (comparisons) between factor smooth
interactions (smooths with a factor \code{by} argument) for pairs of groups
defined by the factor. The group means can be optionally included in the
difference.
}
\examples{

load_mgcv()
\dontshow{
op <- options(pillar.sigfig = 3, cli.unicode = FALSE)
}
df <- data_sim("eg4", seed = 42)
m <- gam(y ~ fac + s(x2, by = fac) + s(x0), data = df, method = "REML")

sm_dif <- difference_smooths(m, select = "s(x2)")
sm_dif

draw(sm_dif)

# include the groups means for `fac` in the difference
sm_dif2 <- difference_smooths(m, select = "s(x2)", group_means = TRUE)
draw(sm_dif2)

# compare specific smooths
sm_dif3 <- difference_smooths(m,
  select = c("s(x2):fac1", "s(x2):fac2"), partial_match = FALSE
)
\dontshow{
options(op)
}
}
