% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convChks.R
\name{ccFun}
\alias{ccFun}
\alias{ccFun,}
\alias{ccFun1,}
\alias{ccFun2,}
\alias{ccFun3,}
\alias{ccFun4}
\alias{ccFun1}
\alias{ccFun2}
\alias{ccFun3}
\title{Convergence Criteria Checks for REML.}
\usage{
ccFun(obj = NULL)

ccFun1(obj = NULL)

ccFun2(obj = NULL)

ccFun3(obj = NULL)

ccFun4(obj = NULL)
}
\arguments{
\item{obj}{Optional gremlin model object. If \code{NULL} then the necessary
variables are taken from the parent environment, if present}
}
\value{
A \code{logical} value whether the current REML iteration has passed
  the convergence criteria
}
\description{
Determine whether the optimization has converged on a maximum of the 
log-likelihood function
}
\examples{
  grS2 <- gremlinR(WWG11 ~ sex, random = ~ sire, data = Mrode11, maxit = 2)
    ccFun1(grS2)
    ccFun2(grS2)
  grS <- gremlinR(WWG11 ~ sex, random = ~ sire, data = Mrode11)
    ccFun(grS)

}
\references{
Meyer, K. 2019. WOMBAT A program for mixed model analyses by restricted
  maximum likelihood. User Notes. 27 September 2019.
}
\author{
\email{matthewwolak@gmail.com}
}
