% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_update_alpha_docs.R
\name{update_alpha}
\alias{update_alpha}
\title{Update colour and/or pattern transparency}
\usage{
update_alpha(fill, alpha)
}
\arguments{
\item{fill}{A fill colour given as a \code{character} or \code{integer} vector, or as a
(list of) \verb{<GridPattern>} object(s) and/or colour(s).}

\item{alpha}{A transparency value between 0 (transparent) and 1 (opaque),
parallel to \code{fill}.}
}
\value{
A \code{character} vector of colours or list of \verb{<GridPattern>} objects.
}
\description{
\code{update_alpha()} modifies the transparency of colours and/or patterns.
}
\details{
\itemize{
\item This is a fork of pattern utilities mainly added to \code{{ggplot2}} by Teun van den Brand.
\item \code{update_alpha()} does not depend on \code{{ggplot2}} or \code{{scales}}.
\item Like \code{\link[ggplot2:fill_alpha]{ggplot2::fill_alpha()}} but unlike \code{\link[scales:alpha]{scales::alpha()}} it also attempts
to set the transparency of \verb{<GridPattern>} objects.
\item Unlike \code{\link[ggplot2:fill_alpha]{ggplot2::fill_alpha()}} it will work on a list of length one
containing a vector of color strings.
}
}
\section{Usage in other packages}{


To avoid taking a dependency on \code{gridpattern} you may copy the source of \code{update_alpha()}
into your own package under the permissive MIT license.  Either use
\code{usethis::use_standalone("trevorld/gridpattern", "standalone-update_alpha.R")}
or copy the file \code{update_alpha.R} into your \code{R} directory and
add \code{grDevices}, \code{grid}, and \code{rlang} to the \code{Imports} of your \code{DESCRIPTION} file.
}

\examples{
# Typical color input
update_alpha("red", 0.5)

# Pattern input
if (getRversion() >= "4.2" && requireNamespace("grid", quietly = TRUE)) {
  update_alpha(list(grid::linearGradient()), 0.5)
}
}
