% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{calc_probabilities}
\alias{calc_probabilities}
\title{Probability for certain degree of saturation}
\usage{
calc_probabilities(r, n, ms, min.props = c(0.9, 0.95, 0.99))
}
\arguments{
\item{r}{A dataframe. The result returned from \code{\link{sim_n_persons_x_times_many_n}}.}

\item{n}{Vector of n for which to calculate probabilities.}

\item{ms}{minimal number of constructs in each category}

\item{min.props}{Proportion of categores to contain at least m constructs.}
}
\description{
Calculate probability for getting certain proportion of categories with at
least m constructs
}
\examples{
prob <-  dexp(1:30, .05)
n <- seq(10, 80, by = 20)
r <- sim_n_persons_x_times_many_n(prob, n, a = 7, times = 100)
dd <- calc_probabilities(r, n, ms=1:5, min.props = c(0.9, .95, 1))
head(dd)

}
\seealso{
Other Utilities: \code{\link{expected_frequencies}},
  \code{\link{prob_categories}}
}

