% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridstackeR.R
\name{grid_stack_item}
\alias{grid_stack_item}
\title{Grid Stack Item}
\usage{
grid_stack_item(
  ...,
  id = NULL,
  autoPosition = NULL,
  x = NULL,
  y = NULL,
  w = NULL,
  h = NULL,
  maxW = NULL,
  minW = NULL,
  maxH = NULL,
  minH = NULL,
  locked = NULL,
  noResize = NULL,
  noMove = NULL,
  resizeHandles = NULL
)
}
\arguments{
\item{...}{content to include in the grid stack item}

\item{id}{the id of the item, used for save and load functions, this param is propagated through to lower levels}

\item{autoPosition}{if set to TRUE x and y attributes are ignored and the element is placed to the first
available position. Having either x or y missing will also do that}

\item{x, y}{element position in columns/rows.
Note: if one is missing this will \code{autoPosition} the item}

\item{w, h}{element size in columns/rows}

\item{maxW, minW, maxH, minH}{element constraints in column/row (default none)}

\item{locked}{means another widget wouldn't be able to move it during dragging or resizing.
The widget can still be dragged or resized by the user.
You need to add \code{noResize} and \code{noMove} attributes to completely lock the widget.}

\item{noResize}{if set to TRUE it disables element resizing}

\item{noMove}{if set to TRUE it disables element moving}

\item{resizeHandles}{- widgets can have their own custom resize handles.
For example 'e,w' will make that particular widget only resize east and west.}
}
\value{
a grid_stack_item to be placed inside a \code{grid_stack}. This item is resizable and draggable by default.
}
\description{
This is a wrapper for the individual items to be displayed in the \link{grid_stack}
Check the \href{https://github.com/gridstack/gridstack.js/tree/master/doc#item-options}{ gridstack documentation}
for more information.

The default for all parameters is an empty string, this will make them disappear for gridstackjs
}
\examples{
\dontrun{
grid_stack_item(
h = 2, w = 2, style = "overflow:hidden",
box(
  title = "gridstackeR", status = "success", solidHeader = TRUE, width = 12, height = "100\%",
  div("Drag and scale the Boxes as desired")
)
)
}

}
