% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uwedge.R
\name{uwedge}
\alias{uwedge}
\title{uwedge}
\usage{
uwedge(Rx, init = NA, rm_x0 = TRUE, return_diag = FALSE, tol = 1e-10,
  max_iter = 1000, n_components = NA, silent = TRUE)
}
\arguments{
\item{Rx}{list of matrices to be diagaonlized.}

\item{init}{matrix used in first step of initialization. If NA a
default based on PCA is used}

\item{rm_x0}{boolean whether to also diagonalize first matrix in
\code{Rx} or only use it for scaling.}

\item{return_diag}{boolean. Specifies whether to return the list
of diagonalized matrices.}

\item{tol}{float, optional. Tolerance for terminating the
iteration.}

\item{max_iter}{int, optional. Maximum number of iterations.}

\item{n_components}{number of components to extract. If NA is
passed, all components are used.}

\item{silent}{boolean whether to supress status outputs.}
}
\value{
object of class 'uwedge' consisting of the following
  elements

\item{V}{joint diagonalizing matrix.}

\item{Rxdiag}{list of diagonalized matrices.}

\item{converged}{boolean specifying whether the algorithm
converged for the given \code{tol}.}

\item{iterations}{number of iterations of the approximate joint
diagonalisation.}

\item{meanoffdiag}{mean absolute value of the off-diagonal values
of the to be jointly diagonalised matrices, i.e., a proxy of the
approximate joint diagonalisation objective function.}
}
\description{
Performs an approximate joint matrix diagonalization on a list of
matrices. More precisely, for a list of matrices Rx the algorithm
finds a matrix V such that for all i V Rx[i] t(V) is approximately
diagonal.
}
\details{
For further details see the references.
}
\examples{
## Example
set.seed(1)

# Generate data 20 matrix that can be jointly diagonalized
d <- 10
A <- matrix(rnorm(d*d), d, d)
A <- A\%*\%t(A)
Rx <- lapply(1:20, function(x) A \%*\% diag(rnorm(d)) \%*\% t(A))

# Perform approximate joint diagonalization
ptm <- proc.time()
res <- uwedge(Rx,
              rm_x0=FALSE,
              return_diag=TRUE,
              max_iter=1000)
print(proc.time()-ptm)

# Average value of offdiagonal elements:
print(res$meanoffdiag)
}
\references{
Pfister, N., S. Weichwald, P. Bühlmann and B. Schölkopf (2017).
GroupICA: Independent Component Analysis for grouped data.
ArXiv e-prints (arXiv:1806.01094).

Tichavsky, P. and Yeredor, A. (2009).
Fast Approximate Joint Diagonalization Incorporating Weight Matrices.
IEEE Transactions on Signal Processing.
}
\seealso{
The function \code{\link{groupICA}} uses \code{uwedge}.
}
\author{
Niklas Pfister and Sebastian Weichwald
}
