% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_functions.R
\name{start_of_growing_season_mtd}
\alias{start_of_growing_season_mtd}
\title{Multicriterial Thermal Definition}
\usage{
start_of_growing_season_mtd(temperatures, first_possible_DOY = 1)
}
\arguments{
\item{temperatures}{vector Daily average temperatures in degree Celsius.}

\item{first_possible_DOY}{int Only consider days of the year from this 
value onward.}
}
\value{
int DOY of the growing season start according to the MTD.
}
\description{
Find the start of the growing season based on daily average temperatures.
}
\details{
This function implements the *multicriterial thermal definition* (MTD) 
as described in chapter 2.3.1.3 of the dissertation of Andreas 
Schaumberger:
Räumliche Modelle zur Vegetations- und Ertragsdynamik im 
Wirtschaftsgrünland, 2011, ISBN-13: 978-3-902559-67-8
}
\examples{
# Create fake temperatures
ts = c(0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 6, 6, 6, 6, 3, 3, 3, 3, 3, 6, 6, 6, 
6, 5, 6, 7, 8, 9, 10, 11, 12)
start_of_growing_season_mtd(ts)

}
\seealso{
[start_of_growing_season()]
}
