% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.R
\name{logLik.grpreg}
\alias{logLik.grpreg}
\alias{logLik}
\alias{logLik.grpsurv}
\title{logLik method for grpreg}
\usage{
\method{logLik}{grpreg}(object, df.method = c("default", "active"), REML = FALSE, ...)

\method{logLik}{grpsurv}(object, df.method = c("default", "active"), ...)
}
\arguments{
\item{object}{A fitted \code{grpreg} or \code{grpsurv} object, as obtained from
\code{\link[=grpreg]{grpreg()}} or \code{\link[=grpsurv]{grpsurv()}}}

\item{df.method}{How should effective model parameters be calculated? One
of: \code{"active"}, which counts the number of nonzero coefficients; or
\code{"default"}, which uses the calculated \code{df} returned by
\code{grpreg}. Default is \code{"default"}.}

\item{REML}{Use restricted MLE for estimation of the scale parameter in a
gaussian model?  Default is FALSE.}

\item{...}{For S3 method compatibility.}
}
\value{
Returns an object of class 'logLik', in this case consisting of a
number (or vector of numbers) with two attributes: 'df' (the estimated
degrees of freedom in the model) and 'nobs' (number of observations).

The 'print' method for 'logLik' objects is not intended to handle vectors;
consequently, the value of the function does not necessarily display
correctly.  However, it works with 'AIC' and 'BIC' without any glitches and
returns the expected vectorized output.
}
\description{
Calculates the log likelihood and degrees of freedom for a fitted grpreg
object.
}
\details{
Exists mainly for use with \code{\link[stats:AIC]{stats::AIC()}} and \code{\link[stats:AIC]{stats::BIC()}}.
}
\examples{
data(Birthwt)
X <- Birthwt$X
y <- Birthwt$bwt
group <- Birthwt$group
fit <- grpreg(X,y,group,penalty="cMCP")
logLik(fit) ## Display is glitchy for vectors
AIC(fit)
BIC(fit)
}
\seealso{
\code{\link[=grpreg]{grpreg()}}
}
\author{
Patrick Breheny
}
