\name{gsa.reshape.concordance.table}
\alias{gsa.reshape.concordance.table}
\title{
Reshape a Concordance Table
}
\description{
Given a GATKReport generated by GenotypeConcordance (as output by \code{gsa.read.gatkreport}), this function reshapes the concordance for a specified sample into a matrix with the EvalGenotypes in rows and the CompGenotypes in columns (see the documentation for GenotypeConcordance for the definition of Eval and Comp)
}
\usage{
gsa.reshape.concordance.table(
  report, 
  table.name="GenotypeConcordance_Counts", 
  sample.name="ALL")
}
\arguments{
  \item{report}{
A GATKReport as output by \code{gsa.read.gatkreport}.  If \code{table.name} is \code{NULL}, \code{report} is assumed to be the vector of concordance values to reshape.
}
  \item{table.name}{
The table name in the GATKReport to reshape.  Defaults to "GenotypeConcordance_Counts", but could also be one of the proportion tables ("GenotypeConcordance_EvalProportions", "GenotypeConcordance_CompProportions").  This value can also be \code{NULL}, in which case \code{report} is reshaped directly.  
}
  \item{sample.name}{
The sample name within \code{table.name} to use.
}
}
\value{
Returns a two-dimensional matrix with Eval genotypes in the rows and Comp genotypes in the columns.  The genotypes themselves (\code{HOM_REF}, \code{NO_CALL}, etc) are specified in the row/col names of the matrix.
}
\author{
Phillip Dexheimer
}

\seealso{
\code{\link{gsa.read.gatkreport}}
}
\examples{
test_file = system.file("extdata", "test_genconcord.table", package = "gsalib")
report = gsa.read.gatkreport(test_file)
gsa.reshape.concordance.table(report)

## Output looks like:
##              CompGenotypes
##EvalGenotypes NO_CALL HOM_REF HET HOM_VAR UNAVAILABLE MIXED
##  NO_CALL     0       0       0       0       0           0    
##  HOM_REF     0       0       0       0       0           0    
##  HET         0       0       13463   90      3901        0    
##  HOM_VAR     0       0       2935    18144   4448        0    
##  UNAVAILABLE 0       0       2053693 1326112 11290       0    
##  MIXED       0       0       0       0       0           0  
}
\keyword{ manip }
