% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blackmannuttall.R
\name{blackmannuttall}
\alias{blackmannuttall}
\title{Blackman-Nuttall window}
\usage{
blackmannuttall(n, method = c("symmetric", "periodic"))
}
\arguments{
\item{n}{Window length, specified as a positive integer.}

\item{method}{Character string. Window sampling method, specified as:
\describe{
  \item{"symmetric" (Default)}{Use this option when using windows for filter
  design.}
  \item{"periodic"}{This option is useful for spectral analysis because it
  enables a windowed signal to have the perfect periodic extension implicit
  in the discrete Fourier transform. When "periodic" is specified, the
  function computes a window of length \code{n + 1} and returns the first
  \code{n} points.}
}}
}
\value{
Blackman-Nuttall window, returned as a vector.
}
\description{
Return the filter coefficients of a Blackman-Nuttal window.
}
\details{
The Blackman-Nuttall window is a member of the family of cosine sum windows.
}
\examples{

b <- blackmannuttall(64)
plot (b, type = "l", xlab = "Samples", ylab =" Amplitude")

bs = blackmannuttall(64,'symmetric')
bp = blackmannuttall(63,'periodic')
plot (bs, type = "l", xlab = "Samples", ylab =" Amplitude")
lines(bp, col="red")

}
\author{
Muthiah Annamalai, \email{muthiah.annamalai@uta.edu}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
