% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_entropy_ice}
\alias{gsw_entropy_ice}
\title{Entropy of ice}
\usage{
gsw_entropy_ice(t, p)
}
\arguments{
\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
entropy [ J/(kg*degC) ]
}
\description{
Entropy of ice
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
t <- c(-10.7856, -13.4329, -12.8103, -12.2600,  -10.8863,  -8.4036)
p <- c(      10,       50,      125,      250,      600,      1000)
e <- gsw_entropy_ice(t, p)
stopifnot(all.equal(e/1e3, c(-1.303663820598987, -1.324090218294577, -1.319426394193644,
                             -1.315402956671801, -1.305426590579231, -1.287021035328113)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_entropy_ice.html}
}
\seealso{
Other things related to entropy: 
\code{\link{gsw_CT_from_entropy}()},
\code{\link{gsw_entropy_first_derivatives}()},
\code{\link{gsw_entropy_from_pt}()},
\code{\link{gsw_entropy_from_t}()},
\code{\link{gsw_pt_from_entropy}()}
}
\concept{things related to entropy}
