% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_ice_fraction_to_freeze_seawater}
\alias{gsw_ice_fraction_to_freeze_seawater}
\title{Ice Fraction to Cool Seawater to Freezing}
\usage{
gsw_ice_fraction_to_freeze_seawater(SA, CT, p, t_Ih)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ].  The valid range for most `gsw`
functions is 0 to 42 g/kg.}

\item{CT}{Conservative Temperature [ degC ].}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{t_Ih}{initial temperature of ice [ degC ]}
}
\value{
a list containing \code{SA_freeze}, \code{CT_freeze} and \code{w_Ih}.
}
\description{
Ice Fraction to Cool Seawater to Freezing
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2022-10-11 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `657216dd4f5ea079b5f0e021a4163e2d26893371`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(   34.7118,  34.8915,  35.0256,  34.8472,  34.7366, 34.7324)
CT <- c(   28.7856,  28.4329,  22.8103,  10.2600,   6.8863,  4.4036)
p <- c(         10,       50,      125,      250,      600,    1000)
t_Ih <- c(-10.7856, -13.4329, -12.8103, -12.2600, -10.8863, -8.4036)
r <- gsw_ice_fraction_to_freeze_seawater(SA, CT, p, t_Ih)
stopifnot(all.equal(r$SA_freeze, c(25.823952352620722, 26.120495895535438, 27.460572941868072,
                                   30.629978769577168, 31.458222332943784, 32.121170316796444)))
stopifnot(all.equal(r$CT_freeze, c(-1.389936216242376, -1.437013334134283, -1.569815847128818,
                                   -1.846419165657020, -2.166786673735941, -2.522730879078756)))
stopifnot(all.equal(r$w_Ih, c(0.256046867272203, 0.251379393389925, 0.215985652155336,
                              0.121020375537284, 0.094378196687535, 0.075181377710828)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_ice_fraction_to_freeze_seawater.html}
}
