% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IgG_inhibition.R
\name{IgG_inhibition}
\alias{IgG_inhibition}
\title{IgG inhibition}
\format{
A \link[tibble:tibble-package]{tibble} with 400 rows and 10 variables:
\describe{
\item{\code{plate}}{Plate identifier.}
\item{\code{well}}{Well identifier. Values are always \code{NA} (not available). This
variable is kept nevertheless to be coherent with other data sets from other
similar R data packages.}
\item{\code{dye}}{The type of dye used. In this data set the values are always
\code{"SYBR"}, meaning SYBR Green I master mix (Roche).}
\item{\code{target}}{Target identifier: the amplicon used, \code{"MT_ND1"}.}
\item{\code{sample_type}}{Sample type (all curves are standards, i.e. \code{"std"}).}
\item{\code{replicate}}{Replicate identifier: 1 thru 3.}
\item{\code{IgG_conc}}{IgG concentration in \eqn{\mu g/ml}.}
\item{\code{copies}}{Standard copy number.}
\item{\code{cycle}}{PCR cycle.}
\item{\code{fluor}}{Raw fluorescence values.}
}
}
\source{
\doi{10.1186/1471-2105-9-326}
}
\description{
This data set is for a set of quantitative real-time PCR runs that were
performed in the presence of an optimal amplification reaction mix added with
serial dilutions of IgG (0.0, 0.25, 0.50, 1.0, and 2.0 \eqn{\mu g/ml}) thus acting as
the inhibitory agent. There are two replicates for each concentration of IgG.
The concentration of the amplicon ND1/ND2 is 41,700,000 copies.
Please read the Methods section of Guescini et al. (2008) for more details.
}
\examples{
IgG_inhibition

}
\keyword{datasets}
