% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto-generated-cli-doc-stubs.R
\name{guild_merge_cli}
\alias{guild_merge_cli}
\title{guild_merge_cli
Copy run files to a project directory.}
\usage{
guild_merge_cli(
  ...,
  filter = NULL,
  operation = NULL,
  label = NULL,
  unlabeled = NA,
  tag = NULL,
  comment = NULL,
  marked = NA,
  unmarked = NA,
  started = NULL,
  digest = NULL,
  running = NA,
  completed = NA,
  error = NA,
  terminated = NA,
  pending = NA,
  staged = NA,
  target_dir = NULL,
  sourcecode = NA,
  all = NA,
  skip_sourcecode = NA,
  skip_deps = NA,
  exclude = NULL,
  no_summary = NA,
  summary_name = NULL,
  preview = NA,
  replace = NA,
  no_replace = NA
)
}
\arguments{
\item{...}{passed on to the \code{guild} executable. Arguments are automatically quoted with \code{shQuote()}, unless they are protected with \code{I()}. Pass \code{'--help'} or \code{help = TRUE} to see all options.}

\item{filter}{Filter runs using a filter expression. See Filter by Expression above for details.}

\item{operation}{Filter runs with operations matching \code{VAL}.}

\item{label}{Filter runs with labels matching VAL. To show unlabeled runs, use \code{unlabeled}.}

\item{unlabeled}{(bool) Filter runs without labels.}

\item{tag}{Filter runs with TAG.}

\item{comment}{Filter runs with comments matching VAL.}

\item{marked}{(bool) Filter marked runs.}

\item{unmarked}{(bool) Filter unmarked runs.}

\item{started}{Filter runs started within RANGE. See above for valid time ranges.}

\item{digest}{Filter runs with a matching source code digest.}

\item{running}{(bool) Filter runs that are still running.}

\item{completed}{(bool) Filter completed runs.}

\item{error}{(bool) Filter runs that exited with an error.}

\item{terminated}{(bool) Filter runs terminated by the user.}

\item{pending}{(bool) Filter pending runs.}

\item{staged}{(bool) Filter staged runs.}

\item{target_dir}{Directory to merge run files to (required if project directory cannot be determined for the run).}

\item{sourcecode}{(bool) Only copy run source code. Implies use of \code{skip_deps}. Cannot be used with \code{skip_sourcecode}.}

\item{all}{(bool) Copy all run files. May be used with \code{skip_sourcecode}, \code{skip_deps}, and \code{exclude} to copy all but the skipped/excluded files.}

\item{skip_sourcecode}{(bool) Don't copy run source code.}

\item{skip_deps}{(bool) Don't copy project-local dependencies.}

\item{exclude}{Exclude a file or pattern (may be used multiple times).}

\item{no_summary}{(bool) Don't generate a run summary.}

\item{summary_name}{Name used for the run summary. Use '${run_id}' in the name to include the run ID.}

\item{preview}{(bool) Show what would happen on a merge.}

\item{replace}{(bool) Allow replacement of existing files. Cannot be used with \code{no_replace}}

\item{no_replace}{(bool) Fail if any target file would be replaced, even if that file is committed to the project VCS. Cannot be used with \code{replace}.}
}
\description{
By default, Guild copies run files into the current directory. To
copy files to a different directory, use \verb{target_dir DIR}.
}
\details{
Guild checks that the run originated from the current directory
before copying files. If the run is associated with a project from
a different directory, or is from a package, Guild exits with an
error message. In this case, use \code{target_dir} to override the
check with an explicit path.

The command fails if any file would be replaced, unless a) the
\code{replace} option is specified or b) the replaced file is
committed to the project VCS and unchanged. To prevent replacement
even when a file is committed to VCS and unchanged, specify
\code{no_replace}.
}
\keyword{internal}
