% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirrored_man_plot.R
\name{mirrored_man_plot}
\alias{mirrored_man_plot}
\title{Mirrored Manhattan Plot}
\usage{
mirrored_man_plot(
  data,
  trait1 = NULL,
  trait2 = NULL,
  trait1_chromCols = c("gray66", "grey36"),
  trait2_chromCols = c("steelblue1", "steelblue4"),
  xlab = "Genomic Position (chromosome)",
  title = "Manhattan Plot",
  annotate_trait1_pval = FALSE,
  annotate_trait1_color = "red",
  annotate_trait2_pval = FALSE,
  annotate_trait2_color = "red",
  annotateSNP = NULL,
  annotateSNPcolor = "red",
  highlight = NULL,
  highlightcolor = "green3",
  genomewideline_trait1 = NULL,
  genomewideline_trait2 = NULL,
  genomewideline_type = "dashed",
  genomewideline_color = "red",
  suggestiveline_trait1 = NULL,
  suggestiveline_trait2 = NULL,
  suggestiveline_type = "dashed",
  suggestiveline_color = "blue"
)
}
\arguments{
\item{data}{A tab-delimited or data frame with the compulsory columns:
"CHR", "SNP", "BP", "P", "Trait".}

\item{trait1}{A character string of the trait1 as it appears in the input data.}

\item{trait2}{A character string of the trait2 as it appears in the input data.}

\item{trait1_chromCols}{A character vector indicating which colors to alternate
for trait1 chromosomes.}

\item{trait2_chromCols}{A character vector indicating which colors to alternate
for trait2 chromosomes.}

\item{xlab}{A character string to be used as the x-axis label.}

\item{title}{A character string to be used as the plot title}

\item{annotate_trait1_pval}{If set, trait1 SNPs with p-value less than or equal to this
p-value will be annotated on the plot.}

\item{annotate_trait1_color}{A character string indicating the color to be used for annotating
trait1 SNPs by p-value}

\item{annotate_trait2_pval}{If set, trait2 SNPs with p-value less than or equal to this
p-value will be annotated on the plot.}

\item{annotate_trait2_color}{A character string indicating the color to be used for annotating
trait2 SNPs by p-value}

\item{annotateSNP}{A character vector of SNPs in your dataset to annotate.
If some of the SNPs are not in your dataset, gwaRs will throw a warning message.}

\item{annotateSNPcolor}{A character string denoting the color to use for the annotations.}

\item{highlight}{A character vector of SNPs in the dataset to highlight.
If some of the SNPs are not in your dataset, gwaRs will throw a warning message. Default is NULL.}

\item{highlightcolor}{A character string denoting the color to use to highlight the SNPs.}

\item{genomewideline_trait1}{Where to draw the "genome-wide significant" line for trait1}

\item{genomewideline_trait2}{Where to draw the "genome-wide significant" line for trait2}

\item{genomewideline_type}{A character string denoting the type of line to be used for the
"genome-wide significant" line. This is the same for both traits. Default is dashed.}

\item{genomewideline_color}{A character string denoting the color to be used for the
"genome-wide significant" line. This is the same for both traits. Default is red.}

\item{suggestiveline_trait1}{Where to draw the "suggestive" line for trait1.}

\item{suggestiveline_trait2}{Where to draw the "suggestive" line for trait2.}

\item{suggestiveline_type}{A character string denoting the type of line to be used for the
"suggestive" line. This is the same for both traits. Default is dashed}

\item{suggestiveline_color}{A character string denoting the color to be used for the
"suggestive" line. This is the same for both traits. Default is blue.}
}
\value{
A Mirrored Manhattan plot for two traits.
}
\description{
Creates a Mirrored Manhattan Plot for two traits
}
\details{
Create a Mirrored Manhattan Plot from a tab-delimited file or data frame with the compulsory
columns: "CHR", "SNP", "BP", "P", "Trait" .
}
\examples{
\dontrun{
mirrored_man_plot(inputData)
}

}
\author{
Lindokuhle Nkambule
}
