% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{env_action_space_info}
\alias{env_action_space_info}
\title{Get information (name and dimensions/bounds) of the environments's action space.}
\usage{
env_action_space_info(x, instance_id)
}
\arguments{
\item{x}{An instance of class "GymClient"; this object has "remote_base" as an attribute.}

\item{instance_id}{A short identifier (such as "3c657dbc") for the environment instance.}
}
\value{
A list containing "name" (such as "Discrete"), and additional dimensional info (such as "n") which varies from space to space.
}
\description{
Get information (name and dimensions/bounds) of the environments's action space.
}
\examples{
\dontrun{
remote_base <- "http://127.0.0.1:5000"
client <- create_GymClient(remote_base)
env_id <- "CartPole-v0"
instance_id <- env_create(client, env_id)
env_action_space_info(client, instance_id)
}
}

