% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{env_step}
\alias{env_step}
\title{Step though an environment using an action.}
\usage{
env_step(x, instance_id, action, render = FALSE)
}
\arguments{
\item{x}{An instance of class "GymClient"; this object has "remote_base" as an attribute.}

\item{instance_id}{A short identifier (such as "3c657dbc") for the environment instance.}

\item{action}{An action to take in the environment.}

\item{render}{Whether to render the environment. Defaults to FALSE.}
}
\value{
A list consisting of the following: action; an action to take in the environment, observation; an agent's observation of the current environment, reward; the amount of reward returned after previous action, done; whether the episode has ended, and info; a list containing auxiliary diagnostic information.
}
\description{
Step though an environment using an action.
}
\examples{
\dontrun{
remote_base <- "http://127.0.0.1:5000"
client <- create_GymClient(remote_base)
env_id <- "CartPole-v0"
instance_id <- env_create(client, env_id)
action <- env_action_space_sample(client, instance_id)
env_step(client, instance_id, action)
}
}

