% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.thresholds_and_metric_scores}
\alias{h2o.thresholds_and_metric_scores}
\title{Retrieve the thresholds and metric scores table}
\usage{
h2o.thresholds_and_metric_scores(
  object,
  train = FALSE,
  valid = FALSE,
  xval = FALSE
)
}
\arguments{
\item{object}{A \linkS4class{H2OBinomialUpliftMetrics} or a \linkS4class{H2OBinomialMetrics}}

\item{train}{Retrieve the training thresholds and metric scores table}

\item{valid}{Retrieve the validation thresholds and metric scores table}

\item{xval}{Retrieve the cross-validation thresholds and metric scores table (only for \linkS4class{H2OBinomialMetrics})}
}
\description{
Retrieves the thresholds and metric scores table from a \linkS4class{H2OBinomialUpliftMetrics} 
or a \linkS4class{H2OBinomialMetrics}.
}
\details{
The table contains indices, thresholds, all cumulative uplift values and cumulative number of observations for 
uplift binomial models or thresholds and maximal metric values for binomial models. 
If "train" and "valid" parameters are FALSE (default), then the training table is returned. If more
than one parameter is set to TRUE, then a named vector of tables is returned, where the names are "train", "valid".
}
\examples{
\dontrun{
library(h2o)
h2o.init()
f <- "https://s3.amazonaws.com/h2o-public-test-data/smalldata/uplift/criteo_uplift_13k.csv"
train <- h2o.importFile(f)
train$treatment <- as.factor(train$treatment)
train$conversion <- as.factor(train$conversion)

model <- h2o.upliftRandomForest(training_frame=train, x=sprintf("f\%s",seq(0:10)), y="conversion",
                                ntrees=10, max_depth=5, treatment_column="treatment", 
                                auuc_type="AUTO")
perf <- h2o.performance(model, train=TRUE) 
h2o.thresholds_and_metric_scores(perf)
}
}
