% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_api.R
\name{cell_to_childpos}
\alias{cell_to_childpos}
\title{Cell to Child position}
\usage{
cell_to_childpos(h3_address = NULL, parent_res = NULL, simple = TRUE)
}
\arguments{
\item{h3_address}{Character; 15-character index generated by H3.}

\item{parent_res}{numeric; resolution of reference parent cell.}

\item{simple}{Logical; whether to return a vector or a data frame containing
both inputs and outputs.}
}
\value{
Numeric, Position of child within parent at `parent_res`.
}
\description{
Get the position of the cell within an ordered list of all children of the cell's parent at the specified resolution.
}
\note{
Function will return 0 if `parent_res` is the same as the resolution of the supplied cell.
}
\examples{
# example address has resolution 7
cell_to_childpos('872830b82ffffff', c(3,4,5,6), simple = FALSE)
}
