% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hJAM_lnreg.R
\name{hJAM_lnreg}
\alias{hJAM_lnreg}
\title{Fit hJAM with linear regression}
\usage{
hJAM_lnreg(betas.Gy, N.Gy, Gl, A, ridgeTerm = FALSE)
}
\arguments{
\item{betas.Gy}{The betas in the paper: the marginal effects of SNPs on the phenotype (Gy)}

\item{N.Gy}{The sample size of Gy}

\item{Gl}{The reference panel (Gl), such as 1000 Genome}

\item{A}{The A matrix in the paper: the marginal/conditional effects of SNPs on the exposures (Gx)}

\item{ridgeTerm}{ridgeTerm = TRUE when the matrix L is singular. Matrix L is obtained from the cholesky
decomposition of G0'G0. Default as FALSE.}
}
\value{
An object of the hJAM with linear regression results.

\describe{
   \item{Exposure}{The intermediates, such as the modifiable risk factors in Mendelian Randomization and gene expression in transcriptome analysis.}
   \item{numSNP}{The number of SNPs that the user use in the instrument set.}
   \item{Estimate}{The conditional estimates of the associations between intermediates and the outcome.}
   \item{StdErr}{The standard error of the conditional estimates of the associations between intermediates and the outcome.}
   \item{Lower.CI}{The lower bound of the 95\% confidence interval of the estimates.}
   \item{Upper.CI}{The upper bound of the 95\% confidence interval of the estimates.}
   \item{Pvalue}{The p value of the estimates with a type-I error equals 0.05.}
}
}
\description{
The hJAM function is to get the results from the hJAM model using input data
}
\examples{
data(Gl)
data(betas.Gy)
data(conditional_A)
hJAM_lnreg(betas.Gy = betas.Gy, Gl = Gl, N.Gy = 459324, A = conditional_A, ridgeTerm = TRUE)

}
\references{
Lai Jiang, Shujing Xu, Nicholas Mancuso, Paul J. Newcombe, David V. Conti (2020).
A Hierarchical Approach Using Marginal Summary Statistics for Multiple Intermediates
in a Mendelian Randomization or Transcriptome Analysis. \emph{bioRxiv}
\url{https://doi.org/10.1101/2020.02.03.924241}.
}
\author{
Lai Jiang
}
