% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflows.R
\name{approx_phi_post}
\alias{approx_phi_post}
\title{Laplace approximation of the posterior of expression fold change phi}
\usage{
approx_phi_post(
  Y_obs,
  lambda_ref,
  d,
  alpha = NULL,
  beta = NULL,
  mu = NULL,
  sig = NULL,
  lower = 0.2,
  upper = 10,
  start = 1
)
}
\arguments{
\item{Y_obs}{numeric vector Gene expression counts}

\item{lambda_ref}{numeric vector Reference expression levels}

\item{d}{numeric Total library size}

\item{alpha}{numeric Shape parameter of the gamma distribution}

\item{beta}{numeric Rate parameter of the gamma distribution}

\item{mu}{numeric Mean of the normal distribution}

\item{sig}{numeric Standard deviation of the normal distribution}

\item{lower}{numeric Lower bound of phi}

\item{upper}{numeric Upper bound of phi}

\item{start}{numeric Starting value of phi}
}
\value{
numeric MLE of phi and its standard deviation
}
\description{
Laplace approximation of the posterior of expression fold change phi
}
\keyword{internal}
