% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{HandlrClient}
\alias{HandlrClient}
\title{HandlrClient}
\description{
handlr client, read and write to and from all citation formats
}
\details{
The various inputs to the \code{x} parameter are handled in different
ways:
\itemize{
\item file: contents read from file, we grab file extension, and we guess
format based on combination of contents and file extension because
file extensions may belie what's in the file
\item string: string read in, and we guess format based on contents of
the string
\item DOI: we request citeproc-json format from the Crossref API
\item DOI url: we request citeproc-json format from the Crossref API
}
}
\note{
If \verb{$parsed} is \code{NULL} then it's likely \verb{$read()} has not
been run - in which case we attempt to run \verb{$read()} to
populate \verb{$parsed}
}
\examples{
# read() can be run with format specified or not
# if format not given, we attempt to guess the format and then read
z <- system.file('extdata/citeproc.json', package = "handlr")
(x <- HandlrClient$new(x = z))
x$read()
x$read("citeproc")
x$parsed

# you can run read() then write()
# or just run write(), and read() will be run for you if possible
z <- system.file('extdata/citeproc.json', package = "handlr")
(x <- HandlrClient$new(x = z))
cat(x$write("ris"))

# read from a DOI as a url
if (interactive()) {
  (x <- HandlrClient$new('https://doi.org/10.7554/elife.01567'))
  x$parsed
  x$read()
  x$parsed
  x$write('bibtex')
}

# read from a DOI
if (interactive()) {
  (x <- HandlrClient$new('10.7554/elife.01567'))
  x$parsed
  x$read()
  x$write('bibtex')
}

# read in citeproc, write out bibtex
z <- system.file('extdata/citeproc.json', package = "handlr")
(x <- HandlrClient$new(x = z))
x$path
x$ext
x$read("citeproc")
x$parsed
x$write("bibtex")
f <- tempfile(fileext = ".bib")
x$write("bibtex", file = f)
readLines(f)
unlink(f)

# read in ris, write out ris
z <- system.file('extdata/peerj.ris', package = "handlr")
(x <- HandlrClient$new(x = z))
x$path
x$format_guessed
x$read("ris")
x$parsed
x$write("ris")
cat(x$write("ris"))

# read in bibtex, write out ris
(z <- system.file('extdata/bibtex.bib', package = "handlr"))
(x <- HandlrClient$new(x = z))
x$path
x$format_guessed
if (requireNamespace("bibtex", quietly = TRUE)) {
x$read("bibtex")
x$parsed
x$write("ris")
cat(x$write("ris"))
}

# read in bibtex, write out RDF XML
if (requireNamespace("bibtex", quietly = TRUE) && interactive()) {
  (z <- system.file('extdata/bibtex.bib', package = "handlr"))
  (x <- HandlrClient$new(x = z))
  x$path
  x$format_guessed
  x$read("bibtex")
  x$parsed
  x$write("rdfxml")
  cat(x$write("rdfxml"))
}

# codemeta
(z <- system.file('extdata/codemeta.json', package = "handlr"))
(x <- HandlrClient$new(x = z))
x$path
x$format_guessed
x$read("codemeta")
x$parsed
x$write("codemeta")

# cff: Citation File Format
(z <- system.file('extdata/citation.cff', package = "handlr"))
(x <- HandlrClient$new(x = z))
x$path
x$format_guessed
x$read("cff")
x$parsed
x$write("codemeta")

# > 1 citation
z <- system.file('extdata/citeproc-many.json', package = "handlr")
(x <- HandlrClient$new(x = z))
x$parsed
x$read()
x$parsed
## schmea org
x$write("schema_org")
## bibtex
x$write("bibtex")
## bibtex to file
f <- tempfile(fileext=".bib")
x$write("bibtex", f)
readLines(f)
unlink(f)
## to RIS
x$write("ris")
### only one per file, so not combined
files <- replicate(2, tempfile(fileext=".ris"))
x$write("ris", files)
lapply(files, readLines)

# handle strings instead of files
z <- system.file('extdata/citeproc-crossref.json', package = "handlr")
(x <- HandlrClient$new(x = readLines(z)))
x$read("citeproc")
x$parsed
cat(x$write("bibtex"), sep = "\n")
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{path}}{(character) non-empty if file path passed to initialize}

\item{\code{string}}{(character) non-empty if string (non-file) passed to initialize}

\item{\code{parsed}}{after \code{read()} is run, the parsed content}

\item{\code{file}}{(logical) \code{TRUE} if a file passed to initialize, else \code{FALSE}}

\item{\code{ext}}{(character) the file extension}

\item{\code{format_guessed}}{(character) the guessed file format}

\item{\code{doi}}{(character) the DOI, if any found}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HandlrClient-print}{\code{HandlrClient$print()}}
\item \href{#method-HandlrClient-new}{\code{HandlrClient$new()}}
\item \href{#method-HandlrClient-read}{\code{HandlrClient$read()}}
\item \href{#method-HandlrClient-write}{\code{HandlrClient$write()}}
\item \href{#method-HandlrClient-as_df}{\code{HandlrClient$as_df()}}
\item \href{#method-HandlrClient-clone}{\code{HandlrClient$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HandlrClient-print"></a>}}
\if{latex}{\out{\hypertarget{method-HandlrClient-print}{}}}
\subsection{Method \code{print()}}{
print method for \code{HandlrClient} objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HandlrClient$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HandlrClient-new"></a>}}
\if{latex}{\out{\hypertarget{method-HandlrClient-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{HandlrClient} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HandlrClient$new(x, format = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(character) a file path (the file must exist), a string
containing contents of the citation, a DOI, or a DOI as a URL.
See Details.}

\item{\code{format}}{(character) one of citeproc, ris, bibtex, codemeta, cff,
or \code{NULL}. If \code{NULL}, we attempt to guess the format, and error if we
can not guess}

\item{\code{...}}{curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{HandlrClient} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HandlrClient-read"></a>}}
\if{latex}{\out{\hypertarget{method-HandlrClient-read}{}}}
\subsection{Method \code{read()}}{
read input
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HandlrClient$read(format = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{format}}{(character) one of citeproc, ris, bibtex, codemeta, cff,
or \code{NULL}. If \code{NULL}, we attempt to guess the format, and error if we
can not guess}

\item{\code{...}}{further args to the writer fxn, if any}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HandlrClient-write"></a>}}
\if{latex}{\out{\hypertarget{method-HandlrClient-write}{}}}
\subsection{Method \code{write()}}{
write to std out or file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HandlrClient$write(format, file = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{format}}{(character) one of citeproc, ris, bibtex, schema_org,
rdfxml, codemeta, or cff}

\item{\code{file}}{a file path, if NULL to stdout. for \code{format=ris},
number of files must equal number of ris citations}

\item{\code{...}}{further args to the writer fxn, if any}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HandlrClient-as_df"></a>}}
\if{latex}{\out{\hypertarget{method-HandlrClient-as_df}{}}}
\subsection{Method \code{as_df()}}{
convert data to a data.frame using \code{\link[=handl_to_df]{handl_to_df()}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HandlrClient$as_df()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a data.frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HandlrClient-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HandlrClient-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HandlrClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
