% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_profiles.R
\name{get_writer_profiles}
\alias{get_writer_profiles}
\title{Estimate Writer Profiles}
\usage{
get_writer_profiles(
  input_dir,
  measure = "counts",
  num_cores = 1,
  template = templateK40,
  writer_indices = NULL,
  doc_indices = NULL,
  output_dir = NULL
)
}
\arguments{
\item{input_dir}{A filepath to a folder containing one or more handwritten
documents, scanned and saved as PNG file(s).}

\item{measure}{A character string: either \code{counts} or \code{rates}. \code{counts}
returns the cluster fill counts, I.e., the number of graphs assigned to
each cluster. \code{rates} returns the cluster fill rates, I.e., the proportion
of graphs assigned to each cluster.}

\item{num_cores}{An integer number greater than or equal to 1 of cores to use
for parallel processing.}

\item{template}{Optional. A cluster template created with
\code{\link{make_clustering_template}}. The default is \code{templateK40}.}

\item{writer_indices}{A vector of start and stop characters for writer IDs in file names}

\item{doc_indices}{A vector of start and stop characters for document names in file names}

\item{output_dir}{Optional. A filepath to a folder to save the RDS files
created by \code{\link{process_batch_dir}} and \code{\link{get_clusters_batch}}. If no folder
is supplied, the RDS files will be saved to the temporary directory and
then deleted before the function terminates.}
}
\value{
A data frame
}
\description{
Estimate writer profiles from handwritten documents scanned and saved as PNG
files. Each file in \code{input_dir} is split into component shapes called graphs
with \code{\link{process_batch_dir}}. Then the graphs are sorted into clusters with
similar shapes using the cluster \code{template} and \code{\link{get_clusters_batch}}. An
estimate of the writer profile for a document is the proportion of graphs
from that document assigned to each of the clusters in \code{template}. The writer
profiles are estimated by running \code{\link{get_cluster_fill_counts}}. If \code{measure}
is \code{counts} than the cluster fill counts are returned. If \code{measure} is
\code{rates} than \code{\link{get_cluster_fill_rates}} is run and the cluster fill rates are
returned.
}
\details{
The functions \code{\link{process_batch_dir}} and \code{\link{get_clusters_batch}} take upwards
of 30 seconds per document and the results are saved to RDS files in
\code{project_dir} > graphs and \code{project_dir} > clusters, respectively. If
\code{project_dir} is NULL than the results are saved to the temporary directory
and deleted before the function terminates.
}
\examples{
\donttest{
docs <- system.file(file.path("extdata"), package = "handwriter")
profiles <- get_writer_profiles(docs, measure = "counts")
plot_writer_profiles(profiles)

profiles <- get_writer_profiles(docs, measure = "rates")
plot_writer_profiles(profiles)
}

}
