% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_fft_sma.R
\name{hanr_fft_sma}
\alias{hanr_fft_sma}
\title{Anomaly Detector using Adaptive FFT and Moving Average}
\usage{
hanr_fft_sma()
}
\value{
\code{hanr_fft_sma} object
}
\description{
This function implements an anomaly detection model based on the Fast Fourier daltoolbox::transform (FFT),
combined with an adaptive moving average filter. The method estimates the dominant frequency
in the input time series using spectral analysis and then applies a moving average filter
with a window size derived from that frequency. This highlights high-frequency deviations,
which are likely to be anomalies.

The residuals (original signal minus smoothed version) are then processed to compute the
distance from the expected behavior, and points significantly distant are flagged as anomalies.
The detection also includes a grouping strategy to reduce false positives by selecting
the most representative point in a cluster of consecutive anomalies.

This function extends the HARBINGER framework and returns an object of class \code{hanr_fft_sma}.
}
\examples{
library(daltoolbox)

# Load anomaly example data
data(examples_anomalies)

#Using simple example
dataset <- examples_anomalies$simple
head(dataset)

# setting up time series fft detector
model <- hanr_fft_sma()

# fitting the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
\references{
\itemize{
\item Sobrinho, E. P., Souza, J., Lima, J., Giusti, L., Bezerra, E., Coutinho, R., Baroni, L.,
Pacitti, E., Porto, F., Belloze, K., Ogasawara, E. Fine-Tuning Detection Criteria for
Enhancing Anomaly Detection in Time Series. In: Simpósio Brasileiro de Banco de Dados
(SBBD). SBC, 29 Sep. 2025. doi:10.5753/sbbd.2025.247063
}
}
