% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hp_palette.R
\name{scale_color_hp}
\alias{scale_color_hp}
\alias{scale_colour_hp}
\alias{scale_colour_hp_d}
\alias{scale_color_hp_d}
\alias{scale_fill_hp_d}
\alias{scale_fill_hp}
\title{Harry Potter colour scales}
\usage{
scale_color_hp(
  option = "Always",
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  discrete = FALSE,
  house = NULL
)

scale_colour_hp(
  option = "Always",
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  discrete = FALSE,
  house = NULL
)

scale_colour_hp_d(
  option = "Always",
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1
)

scale_color_hp_d(
  option = "Always",
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1
)

scale_fill_hp_d(
  option = "Always",
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1
)

scale_fill_hp(
  option = "Always",
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  discrete = FALSE,
  house = NULL
)
}
\arguments{
\item{option}{A character string indicating the colourmap  to use.
Four houses are available: "Gryffindor", "Slytherin", "Ravenclaw" and "Hufflepuff".}

\item{...}{parameters to \code{discrete_scale} or \code{scale_fill_gradientn}}

\item{alpha}{pass through parameter to \code{hp}}

\item{begin}{The (corrected) hue in [0,1] at which the hp colormap begins.}

\item{end}{The (corrected) hue in [0,1] at which the hp colormap ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors
are as output by \code{hp_pal}. If -1, the order of colors is reversed.}

\item{discrete}{generate a discrete palette? (default: \code{FALSE} - generate continuous palette)}

\item{house}{A character string indicating the colourmap from a option to use. This parameter is deprectaed, 'option' should be used instead.
Four houses are available: "Gryffindor", "Slytherin", "Ravenclaw" and "Hufflepuff".}
}
\description{
Uses the Harry Potter color scale.
}
\details{
For \code{discrete == FALSE} (the default) all other arguments are as to
\link[ggplot2]{scale_fill_gradientn} or \link[ggplot2]{scale_color_gradientn}.
Otherwise the function will return a \code{discrete_scale} with the plot-computed
number of colors.
}
\examples{
library(ggplot2)



ggplot(mtcars, aes(factor(cyl), fill=factor(vs))) +
geom_bar() +
scale_fill_hp(discrete = TRUE, option = "Ravenclaw")

ggplot(mtcars, aes(factor(gear), fill=factor(carb))) +
geom_bar() +
scale_fill_hp(discrete = TRUE, option = "Slytherin")

ggplot(mtcars, aes(x = mpg, y = disp, colour = hp)) +
geom_point(size = 2) +
scale_colour_hp(option = "Gryffindor")




}
\author{
Alejandro Jiménez Rico \email{aljrico@gmail.com}
}
