#' `HCE1`, `HCE2`, `HCE3`, `HCE4` datasets for 1000 patients with different treatment effects.
#'
#' A simulated dataset containing the ordinal values and other attributes for 1000 patients.
#' HCE1
#'
#' @format a data frame with 1000 rows and 6 variables:
#' \describe{
#'   \item{ID}{subject ID, numbers from 1 to 1000}
#'   \item{TRTP}{treatment values, A Active or P Placebo, character}
#'   \item{GROUP}{type of the event, either Time-To-Event (TTE) or Continuous (C), character}
#'   \item{GROUPN}{type of the event, for the ordering of outcomes in the `GROUP` variable, numeric}
#'   \item{AVALT}{the timing of the time-to-event outcomes, numeric}
#'   \item{AVAL0}{original values for each type of the event, time for TTE outcomes, numeric values for Continuous outcomes, numeric}
#'   \item{AVAL}{`AVAL = AVAL0 + GROUPN`, ordinal analysis values for the HCE analysis. For the continuous outcome the values of `AVAL0` are shifted to start always from 0. Numeric, but caution NOT to apply numeric operations; will give meaningless results}
#'   \item{PADY}{ primary analysis day, the length of fixed follow-up in days, numeric}
#' }
"HCE1"

#' `HCE1`, `HCE2`, `HCE3`, `HCE4` datasets for 1000 patients with different treatment effects.
#'
#' A simulated dataset containing the ordinal values and other attributes for 1000 patients.
#' HCE2
#'
#' @format a data frame with 1000 rows and 6 variables:
#' \describe{
#'   \item{ID}{subject ID, numbers from 1 to 1000}
#'   \item{TRTP}{treatment values, A Active or P Placebo, character}
#'   \item{GROUP}{type of the event, either Time-To-Event (TTE) or Continuous (C), character}
#'   \item{GROUPN}{type of the event, for the ordering of outcomes in the `GROUP` variable, numeric}
#'   \item{AVALT}{the timing of the time-to-event outcomes, numeric}
#'   \item{AVAL0}{original values for each type of the event, time for TTE outcomes, numeric values for Continuous outcomes, numeric}
#'   \item{AVAL}{`AVAL = AVAL0 + GROUPN`, ordinal analysis values for the HCE analysis. For the continuous outcome the values of `AVAL0` are shifted to start always from 0. Numeric, but caution NOT to apply numeric operations; will give meaningless results}
#'   \item{PADY}{ primary analysis day, the length of fixed follow-up in days, numeric}
#' }
"HCE2"

#' `HCE1`, `HCE2`, `HCE3`, `HCE4` datasets for 1000 patients with different treatment effects.
#'
#' A simulated dataset containing the ordinal values and other attributes for 1000 patients.
#' HCE3
#'
#' @format a data frame with 1000 rows and 6 variables:
#' \describe{
#'   \item{ID}{subject ID, numbers from 1 to 1000}
#'   \item{TRTP}{treatment values, A Active or P Placebo, character}
#'   \item{GROUP}{type of the event, either Time-To-Event (TTE) or Continuous (C), character}
#'   \item{GROUPN}{type of the event, for the ordering of outcomes in the `GROUP` variable, numeric}
#'   \item{AVALT}{the timing of the time-to-event outcomes, numeric}
#'   \item{AVAL0}{original values for each type of the event, time for TTE outcomes, numeric values for Continuous outcomes, numeric}
#'   \item{AVAL}{`AVAL = AVAL0 + GROUPN`, ordinal analysis values for the HCE analysis. For the continuous outcome the values of `AVAL0` are shifted to start always from 0. Numeric, but caution NOT to apply numeric operations; will give meaningless results}
#'   \item{PADY}{ primary analysis day, the length of fixed follow-up in days, numeric}
#' }
"HCE3"


#' `HCE1`, `HCE2`, `HCE3`, `HCE4` datasets for 1000 patients with different treatment effects.
#'
#' A simulated dataset containing the ordinal values and other attributes for 1000 patients.
#' HCE4
#'
#' @format a data frame with 1000 rows and 6 variables:
#' \describe{
#'   \item{ID}{subject ID, numbers from 1 to 1000}
#'   \item{TRTP}{treatment values, A Active or P Placebo, character}
#'   \item{GROUP}{type of the event, either Time-To-Event (TTE) or Continuous (C), character}
#'   \item{GROUPN}{type of the event, for the ordering of outcomes in the `GROUP` variable, numeric}
#'   \item{AVALT}{the timing of the time-to-event outcomes, numeric}
#'   \item{AVAL0}{original values for each type of the event, time for TTE outcomes, numeric values for Continuous outcomes, numeric}
#'   \item{AVAL}{`AVAL = AVAL0 + GROUPN`, ordinal analysis values for the HCE analysis. For the continuous outcome the values of `AVAL0` are shifted to start always from 0. Numeric, but caution NOT to apply numeric operations; will give meaningless results}
#'   \item{PADY}{ primary analysis day, the length of fixed follow-up in days, numeric}
#' }
"HCE4"


#' COVID-19 ordinal scale dataset (full report).
#'
#' A dataset with COVID-19 ordinal scale outcomes for 1062 patients.
#'
#' @format a data frame with 1062 rows and 2 variables:
#' \describe{
#'   \item{GROUP}{type of the event, ordinal outcomes 1-8, where a higher value means a better outcome}
#'   \item{TRTP}{treatment values, A Active or P Placebo, character}
#' }
#' @source Beigel JH et al. "Remdesivir for the treatment of Covid-19-final report." New England Journal of Medicine 383.19 (2020): 1813-1836. <doi:10.1056/NEJMoa2007764>.
#' @examples
#' #Frequencies
#' table(COVID19)
#' mosaicplot(table(COVID19), col = c(1, 8, 6, 2, 4, 5, 3, 7), 
#' xlab = "Treatment", ylab = "Ordinal Scale", main = "COVID-19 ordinal scale")
#' # Convert to an hce object
#' COVID19HCE <- hce(GROUP = COVID19$GROUP, TRTP = COVID19$TRTP)
#' # Summary wins, losses, and ties with win odds
#' summaryWO(COVID19HCE, ref = "Placebo")
"COVID19"


#' COVID-19 ordinal scale dataset (preliminary report).
#'
#' A dataset with COVID-19 ordinal scale outcomes for 844 patients.
#'
#' @format a data frame with 844 rows and 2 variables:
#' \describe{
#'   \item{GROUP}{type of the event, ordinal outcomes 1-8, where a higher value means a better outcome}
#'   \item{TRTP}{treatment values, Active or Placebo, character}
#' }
#' @source Beigel JH et al. "Remdesivir for the treatment of Covid-19-final report." New England Journal of Medicine 383.19 (2020): 1813-1836. <doi:10.1056/NEJMoa2007764>.
#' @examples
#' #Frequencies
#' table(COVID19b)
#' mosaicplot(table(COVID19b), col = c(1, 8, 6, 2, 4, 5, 3, 7), 
#' xlab = "Treatment", ylab = "Ordinal Scale", main = "COVID-19 ordinal scale")
#' # Calculate win statistics
#' calcWINS(x = COVID19b, AVAL = "GROUP", TRTP = "TRTP", ref = "Placebo")
"COVID19b"


#' COVID-19 ordinal scale dataset for a combination therapy.
#'
#' A dataset with COVID-19 ordinal scale outcomes for 1033 patients.
#'
#' @format a data frame with 1033 rows and 4 variables:
#' \describe{
#'   \item{ID}{patient identifiers, numeric}
#'   \item{TRTP}{treatment values, A Active or P Placebo, character}
#'   \item{GROUP}{type of the event, ordinal outcomes 1-8, where a higher value means a better outcome}
#'   \item{BASE}{baseline ordinal values}
#' }
#' @source Kalil AC et al. "Baricitinib plus Remdesivir for Hospitalized Adults with Covid-19." New England Journal of Medicine 384.9 (2021): 795-807. <doi:10.1056/NEJMoa2031994>.
#' @examples
#' COVID19HCE <- hce(GROUP = COVID19plus$GROUP, TRTP = COVID19plus$TRTP)
#' # Summary wins, losses, and ties with win odds
#' summaryWO(COVID19HCE, ref = "P")
"COVID19plus"


#' Kidney Hierarchical Composite Endpoint dataset.
#'
#' A dataset with kidney ordinal scale outcomes of 1500 patients in the `ADSL` dataset.
#'
#' @format a data frame with 1500 rows and 11 variables:
#' \describe{
#'   \item{ID}{patient identifiers, numeric}
#'   \item{TRTPN}{treatment values, 1 Active or 2 Placebo, numeric}
#'   \item{AVAL0}{original values for each type of the event, time for TTE outcomes 1-6, numeric values for Continuous outcome 7, numeric}
#'   \item{AVAL}{`AVAL = AVAL0 + GROUPN`, ordinal analysis values for the HCE analysis, numeric, but caution NOT to apply numeric operations; will give meaningless results}
#'   \item{GROUP}{name of the event, character}
#'   \item{GROUPN}{ordinal outcomes corresponding to `PARAMN` values, numeric}
#'   \item{PARAMCD}{coded name of the event, character}
#'   \item{PARAMN}{severity of the event, outcomes 1-7, where a higher value means a better outcome, character}
#'   \item{STRATAN}{strata 1-4, higher value means more severe kidney disease, numeric}
#'   \item{EGFRBL}{Baseline GFR values of patients, numeric}
#'   \item{TRTP}{treatment values, A Active or P Placebo, character}
#'   \item{PADY}{primary analysis day (in years), length of the fixed follow-up, numeric}
#' }
#' @source 
#' Heerspink HL et al "Development and validation of a new hierarchical composite endpoint for clinical trials of kidney disease progression." Journal of the American Society of Nephrology (2023): <doi:10.1681/ASN.0000000000000243>.
#' @examples
#' # Adjusted win odds
#' res <- regWO(x = KHCE, AVAL = "AVAL", TRTP = "TRTP", COVAR = "STRATAN", ref = "P")
#' res
#' # Convert the dataset to an adhce object.
#' ## First check that `GROUP` is a factor with the correct ordering of outcomes.
#' class(KHCE$GROUP) # "factor"
#' levels(KHCE$GROUP)
#' dat1 <- as_hce(KHCE)
#' class(dat1)
#' calcWO(dat1)
#' ## Re-derive individual patient eGFR slopes using a linear regression model, 
#' ## based on the eGFR measurements in the `ADLB` dataset
#' dat2 <- KHCE
#' l <- lapply(
#' split(ADLB, ADLB$ID), 
#' function(x) coef(lm(AVAL ~ ADAY, data = x))[2])
#' new_slopes <- do.call(rbind, l)
#' new_slopes <- as.data.frame(new_slopes)
#' names(new_slopes) <- "LINEAR"
#' new_slopes$ID <- as.numeric(row.names(new_slopes))
#' dat2 <- merge(KHCE, new_slopes, by = "ID", all.x = TRUE)
#' dat2$AVAL0[dat2$PARAMCD == "eGFR"] <- dat2$LINEAR[dat2$PARAMCD == "eGFR"]
#' dat2$AVAL0[is.na(dat2$AVAL0)] <- 0 
#' dat2 <- as_hce(dat2)
#' calcWO(dat2)
"KHCE"



#' Event-Time dataset for kidney outcomes.
#'
#' A dataset with multiple kidney outcomes over time scale outcomes of 1500 patients in the `ADSL` dataset.
#'
#' @format a data frame with 604 rows (events) and 6 variables:
#' \describe{
#'   \item{ID}{patient identifiers, numeric}
#'   \item{AVAL}{occurence time of the event, numeric}
#'   \item{PARAM}{name of the event, character}
#'   \item{PARAMCD}{coded name of the event, character}
#'   \item{PARAMN}{type of the event, outcomes 1-7, where a higher value means a better outcome, numeric}
#'   \item{TRTPN}{treatment values, 1 Active or 2 Placebo, numeric}
#' }
#' @source
#' Heerspink HL et al "Development and validation of a new hierarchical composite endpoint for clinical trials of kidney disease progression." Journal of the American Society of Nephrology (2023): <doi:10.1681/ASN.0000000000000243>. 
#' @examples
#' head(ADET)
#' # Number of unique patients
#' length(unique(ADET$ID)) 
#' # Number of events per event type
#' barplot(table(ADET$PARAM))
"ADET"



#' Laboratory dataset for Glomerular Filtration Rate (GFR) measurements.
#'
#' A dataset of laboratory measurements of kidney function over time for the 1500 patients in the `ADSL` dataset.
#'
#' @format a data frame with 13980 rows and 8 variables:
#' \describe{
#'   \item{ID}{patient identifiers, numeric}
#'   \item{TRTPN}{treatment values, 1 Active or 2 Placebo, numeric}
#'   \item{AVAL}{measurement value, numeric}
#'   \item{ADAY}{measurement day in the study, numeric}
#'   \item{AVISITN}{hospital visit number, numeric}
#'   \item{PARAM}{name of the event, GFR measurements, character}
#'   \item{PARAMCD}{coded name of the event, GFR, character}
#'   \item{PARAMN}{type of the event is set to 7 for all measurements, numeric}
#' }
#' @source 
#' Heerspink HL et al "Development and validation of a new hierarchical composite endpoint for clinical trials of kidney disease progression." Journal of the American Society of Nephrology (2023): <doi:10.1681/ASN.0000000000000243>.
#' @examples
#' head(ADLB)
"ADLB"



#' Baseline characteristics dataset of patients with kidney function assessments.
#'
#' A data frame with baseline characteristics for 1500 patients used to derive `KHCE` dataset.
#'
#' @format a data frame with 1500 rows and 4 variables:
#' \describe{
#'   \item{ID}{patient identifiers, numeric}
#'   \item{TRTPN}{treatment values, 1 Active or 2 Placebo, numeric}
#'   \item{EGFRBL}{Baseline GFR values of patients, numeric}
#'   \item{STRATAN}{strata 1-4, higher value means a higher risk for kidney disease progression, numeric}
#' }
#' @source 
#' Heerspink HL et al "Development and validation of a new hierarchical composite endpoint for clinical trials of kidney disease progression." Journal of the American Society of Nephrology (2023): <doi:10.1681/ASN.0000000000000243>.
#' @examples
#' head(ADSL)
"ADSL"