% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{COVID19plus}
\alias{COVID19plus}
\title{COVID-19 ordinal scale dataset for a combination therapy.}
\format{
a data frame with 1033 rows and 4 variables:
\describe{
\item{ID}{patient identifiers, numeric}
\item{TRTP}{treatment values, A Active or P Placebo, character}
\item{GROUP}{type of the event, ordinal outcomes 1-8, where a higher value means a better outcome}
\item{BASE}{baseline ordinal values}
}
}
\source{
Kalil AC et al. "Baricitinib plus Remdesivir for Hospitalized Adults with Covid-19." New England Journal of Medicine 384.9 (2021): 795-807. \url{doi:10.1056/NEJMoa2031994}.
}
\usage{
COVID19plus
}
\description{
A dataset with COVID-19 ordinal scale outcomes for 1033 patients.
}
\examples{
COVID19HCE <- hce(GROUP = COVID19plus$GROUP, TRTP = COVID19plus$TRTP)
# Summary wins, losses, and ties with win odds
summaryWO(COVID19HCE, ref = "P")
}
\keyword{datasets}
