% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist.R
\name{hist_end}
\alias{hist_end}
\title{Adjust a design based on historical controls at the end of the study using the covariate data of the patients accrued in stage 2.}
\usage{
hist_end(interim, stagetwo_data)
}
\arguments{
\item{interim}{An design based on historical controls and adjusted at interim as returned by \code{hist_interim()}.}

\item{stagetwo_data}{A dataframe containing the relevant covariate data of the patients accrued in stage 2.}
}
\value{
A list returning the arguments of the function and the final design of the trial.
}
\description{
Adjust a design based on historical controls at the end of the study using the covariate data of the patients accrued in stage 2.
}
\examples{
X <- abs(rnorm(1000, 0, 1))
Y <- rbinom(1000, 1, 1-exp(-X))
mydata <- data.frame("X" = X, "Y" = Y)
start <- hist_start(mydata, Y~X, c1 = 2)
n1 <- start$des_start[2]
X1 <- abs(rnorm(n1, 0, 1))
dataone <- data.frame("X" = X1)
interim <- hist_interim(start, dataone)
n2 <- interim$des_interim[4]
X2 <- abs(rnorm(n2, 0, 1))
datatwo <- data.frame("X" = X2)
hist_end(interim, datatwo)
}
