% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist.R
\name{hist_start}
\alias{hist_start}
\title{Initializes a design based on historical controls before the start of the study.}
\usage{
hist_start(hist_data, formula, phi = "odds_ratio", c1, modelfit = NULL,
  mean0 = NULL, mean1 = NULL, alpha = 0.05, beta = 0.2)
}
\arguments{
\item{hist_data}{A data frame containing covariates and binary responses for historical controls.}

\item{formula}{A formula which is used for fitting a logistic regression model on the historical data.}

\item{phi}{The relation between the response rate under the null and the response rate under the interesting alternative.
"odds_ratio" assumes that the odds ratio (OR) between these response rates is constant with OR = \code{c1+1}.
"difference" assumes that the response rate under the alternative is \code{c1} higher than under the null.
 Can also be specified by the user by providing a function with arguments \code{c} and \code{x}.}

\item{c1}{parameter for obtaining the response rate under the alternative, see description of phi.}

\item{modelfit}{Can be used instead of \code{formula} and \code{hist_data} to provide an arbitrary fitted model that is
compatible with \code{predict(modelfit, type="response")}. \code{formula} and \code{hist_data} are ignored if \code{modelfit} is
specified.}

\item{mean0}{Optional: Can be used to overwrite the estimated average response rate under the null of the fitted model.}

\item{mean1}{Optional: Can be used to overwrite the estimated average response rate under the alternative of the fitted model.}

\item{alpha}{Specified type I error of the trial.}

\item{beta}{Specified type II error of the trial.}
}
\value{
A list returning the arguments of the function and the preliminary design for starting the stratified trial.
}
\description{
Initializes a design based on historical controls before the start of the study.
}
\examples{
X <- abs(rnorm(1000, 0, 1))
Y <- rbinom(1000, 1, 1-exp(-X))
mydata <- data.frame("X" = X, "Y" = Y)
hist_start(mydata, Y~X, c1 = 2)
}
