% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curepwe_leap.R
\name{curepwe.leap}
\alias{curepwe.leap}
\title{Posterior of latent exchangeability prior (LEAP)}
\usage{
curepwe.leap(
  formula,
  data.list,
  breaks,
  K = 2,
  prob.conc = NULL,
  gamma.lower = 0,
  gamma.upper = 1,
  beta.mean = NULL,
  beta.sd = NULL,
  base.hazard.mean = NULL,
  base.hazard.sd = NULL,
  logit.pcured.mean = NULL,
  logit.pcured.sd = NULL,
  get.loglik = FALSE,
  iter_warmup = 1000,
  iter_sampling = 1000,
  chains = 4,
  ...
)
}
\arguments{
\item{formula}{a two-sided formula giving the relationship between the response variable and covariates in
the PWE model. The response is a survival object as returned by the \code{survival::Surv(time, event)}
function, where event is a binary indicator for event (0 = no event, 1 = event has occurred).
The type of censoring is assumed to be right-censoring.}

\item{data.list}{a list of \code{data.frame}s. The first element in the list is the current data, and the rest
are the historical data sets. For fitting CurePWE models, all historical data sets will be stacked
into one historical data set.}

\item{breaks}{a numeric vector specifying the time points that define the boundaries of the piecewise
intervals. The values should be in ascending order, with the final value being greater than
or equal to the maximum observed time.}

\item{K}{the desired number of classes to identify. Defaults to 2.}

\item{prob.conc}{a scalar or a vector of length \code{K} giving the concentration parameters for Dirichlet prior.
If length == 2, a \code{Beta(prob.conc[1], prob.conc[2])} prior is used. If a scalar is provided,
\code{prob.conc} will be a vector of repeated elements of the given scalar. Defaults to a vector of 1s.}

\item{gamma.lower}{a scalar giving the lower bound for probability of subjects in historical data being exchangeable
with subjects in current data. Defaults to 0.}

\item{gamma.upper}{a scalar giving the upper bound for probability of subjects in historical data being exchangeable
with subjects in current data. Defaults to 1.}

\item{beta.mean}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the mean parameters for the initial prior on regression coefficients. If a scalar is provided,
\code{beta.mean} will be a vector of repeated elements of the given scalar. Defaults to a vector of 0s.}

\item{beta.sd}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the sd parameters for the initial prior on regression coefficients. If a scalar is provided,
same as for \code{beta.mean}. Defaults to a vector of 10s.}

\item{base.hazard.mean}{a scalar or a vector whose dimension is equal to the number of intervals giving the location
parameters for the half-normal priors on the baseline hazards of the PWE model. If a scalar is
provided, same as for \code{beta.mean}. Defaults to 0.}

\item{base.hazard.sd}{a scalar or a vector whose dimension is equal to the number of intervals giving the scale
parameters for the half-normal priors on the baseline hazards of the PWE model. If a scalar is
provided, same as for \code{beta.mean}. Defaults to 10.}

\item{logit.pcured.mean}{mean parameter for the normal prior on the logit of the cure fraction \eqn{\pi}. Defaults to 0.}

\item{logit.pcured.sd}{sd parameter for the normal prior on the logit of the cure fraction \eqn{\pi}. Defaults to 3.}

\item{get.loglik}{whether to generate log-likelihood matrix. Defaults to FALSE.}

\item{iter_warmup}{number of warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_warmup} in
\code{sample()} method in cmdstanr package.}

\item{iter_sampling}{number of post-warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_sampling}
in \code{sample()} method in cmdstanr package.}

\item{chains}{number of Markov chains to run. Defaults to 4. See the argument \code{chains} in \code{sample()} method in
cmdstanr package.}

\item{...}{arguments passed to \code{sample()} method in cmdstanr package (e.g., \code{seed}, \code{refresh}, \code{init}).}
}
\value{
The function returns an object of class \code{draws_df} containing posterior samples. The object has two attributes:

\describe{
\item{data}{a list of variables specified in the data block of the Stan program}

\item{model}{a character string indicating the model name}
}
}
\description{
Sample from the posterior distribution of a mixture cure rate model (referred to as the \strong{CurePWE model})
using the latent exchangeability prior (LEAP) by Alt et al. (2024) \url{doi:10.1093/biomtc/ujae083}. The CurePWE model
assumes that a fraction \eqn{\pi} of the population is "cured", while the remaining \eqn{1 - \pi} are susceptible
to the event of interest. The survival function for the entire population is given by:
\deqn{S_{\text{pop}}(t) = \pi + (1 - \pi) S(t),}
where \eqn{S(t)} represents the survival function of the non-cured individuals. We model \eqn{S(t)} using a
piecewise exponential (PWE) model (i.e., a proportional hazards model with a piecewise constant baseline hazard).
Covariates are incorporated through the PWE model.
}
\details{
The latent exchangeability prior (LEAP) discounts the historical data by identifying the most relevant individuals
from the historical data. It is equivalent to a prior induced by the posterior of a finite mixture model for the
historical data set.
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  if(requireNamespace("survival")){
    library(survival)
    data(E1684)
    data(E1690)
    ## take subset for speed purposes
    E1684 = E1684[1:100, ]
    E1690 = E1690[1:50, ]
    ## replace 0 failure times with 0.50 days
    E1684$failtime[E1684$failtime == 0] = 0.50/365.25
    E1690$failtime[E1690$failtime == 0] = 0.50/365.25
    E1684$cage = as.numeric(scale(E1684$age))
    E1690$cage = as.numeric(scale(E1690$age))
    data_list = list(currdata = E1690, histdata = E1684)
    nbreaks = 3
    probs   = 1:nbreaks / nbreaks
    breaks  = as.numeric(
      quantile(E1690[E1690$failcens==1, ]$failtime, probs = probs)
    )
    breaks  = c(0, breaks)
    breaks[length(breaks)] = max(10000, 1000 * breaks[length(breaks)])
    curepwe.leap(
      formula = survival::Surv(failtime, failcens) ~ treatment + sex + cage + node_bin,
      data.list = data_list,
      breaks = breaks,
      K = 2,
      logit.pcured.mean = 0, logit.pcured.sd = 3,
      chains = 1, iter_warmup = 500, iter_sampling = 1000
    )
  }
}
}
\references{
Alt, E. M., Chang, X., Jiang, X., Liu, Q., Mo, M., Xia, H. M., and Ibrahim, J. G. (2024). LEAP: The latent exchangeability prior for borrowing information from historical data. Biometrics, 80(3).
}
