% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdcate_main_operators.R
\name{HDCATE.set_condition_var}
\alias{HDCATE.set_condition_var}
\title{Set the conditional variable in CATE}
\usage{
HDCATE.set_condition_var(
  HDCATE_model,
  name = NA,
  min = NA,
  max = NA,
  step = NA
)
}
\arguments{
\item{HDCATE_model}{an object created via \link{HDCATE}}

\item{name}{name of the conditional variable}

\item{min}{minimum value of the conditional variable for evaluation}

\item{max}{maximum value of the conditional variable for evaluation}

\item{step}{minimum distance between two evaluation points}
}
\value{
None. The \code{HDCATE_model} is ready to fit.
}
\description{
Set the conditional variable in CATE
}
\examples{
# get simulation data
n_obs <- 500  # Num of observations
n_var <- 100  # Num of observed variables
n_rel_var <- 4  # Num of relevant variables
data <- HDCATE.get_sim_data(n_obs, n_var, n_rel_var)
# conditional expectation model is misspecified
x_formula <- paste(paste0('X', c(2:n_var)), collapse ='+')
# propensity score model is misspecified
# x_formula <- paste(paste0('X', c(1:(n_var-1))), collapse ='+')

# create a new HDCATE model
model <- HDCATE(data=data, y_name='Y', d_name='D', x_formula=x_formula)

HDCATE.set_condition_var(model, 'X2', min=-1, max=1, step=0.01)
}
