% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_calc.R
\name{div_calc}
\alias{div_calc}
\title{Diversion Ratio Calculator}
\usage{
div_calc(
  data,
  cell = "cell",
  provider_id = "provider_id",
  provider = "provider",
  sys_id = "sys_id",
  focal_sys_id = NULL,
  party_ind = "party_ind",
  count = "count",
  dropDegenerateCell = TRUE,
  hosp_id = NA,
  hospital = NA
)
}
\arguments{
\item{data}{Dataset of patient choices, with required variables:
\code{cell}, \code{provider_id}, \code{hospital}, \code{sys_id},
\code{party_ind}, \code{count}. Use other function arguments to
indicate alternative variable names to the default names.}

\item{cell}{Name of variable specifying cell to which each observation
has been allocated. Default variable name is \code{cell}. Can be
created by \code{cell_defn} function.}

\item{provider_id}{Name of variable specifying (numeric) provider
identifier. Default variable name is \code{provider_id}.}

\item{provider}{Name of variable specifying (string) provider name.
Default variable name is \code{provider}.}

\item{sys_id}{Name of variable specifying (numeric) system identifier.
Default variable name is \code{sys_id}.}

\item{focal_sys_id}{numeric; list of sys_id's specifying systems of interest
for which diversions will be calculated from. For a merger, this will
typically be the system identifies of the merging parties.}

\item{party_ind}{deprecated; use focal_sys_id instead.}

\item{count}{Name of variable indicating the number of admissions
represented by the observation. Set = 1 for every row if each
observation represents one admission.}

\item{dropDegenerateCell}{logical; specifies how to treat cells with a
100 percent within-system share. If TRUE, observations in degenerate, 100
percent share cells will be ignored in the diversion ratio calculation.
If FALSE, any such individuals will be assigned to the outside option,
but still included in the denominator, so that the inside-option diversion
will total less than 100  percent.}

\item{hosp_id}{deprecated; use provider_id instead.}

\item{hospital}{deprecated; use provider instead.}
}
\value{
A list with two components. The first component, \code{provider_level},
is a matrix giving provider-level diversions from party providers to
all other providers The second object, \code{sys_level}, is a matrix that
aggregates party providers to systems, thus giving diversions from party
systems to all other providers
}
\description{
Calculates provider-level diversion ratios, once cells have been
defined.
}
\details{
For system-to-system diversions, set \code{provider_id} and
\code{provider} equal to corresponding system-level identifiers.
Diversions then reflect that patients are not allowed to divert to
within-system alternative providers

For more details see the example vignette by typing:
\code{vignette("semipar_example", package = "healthcare.antitrust")}
}
\examples{
data(discharge_data, package = "healthcare.antitrust")

list1 <- c("drg","age","zip5")
layers <- list(list1)
th <- 15
discharge_data$count <- 1

outList <- cell_defn(discharge_data,th,layers)
D0 <- outList$assigned

out <- div_calc(D0, provider_id = "hosp_id", provider = "hospital",
          focal_sys_id = c(1,5))

}
