% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aci.R
\name{aci}
\alias{aci}
\title{Absolute concentration index (ACI)}
\usage{
aci(
  est,
  subgroup_order,
  pop = NULL,
  weight = NULL,
  psu = NULL,
  strata = NULL,
  fpc = NULL,
  lmin = NULL,
  lmax = NULL,
  conf.level = 0.95,
  force = FALSE,
  ...
)
}
\arguments{
\item{est}{The indicator estimate. Estimates must be available for all
subgroups/individuals (unless force=TRUE).}

\item{subgroup_order}{The order of subgroups/individuals in an increasing
sequence.}

\item{pop}{For disaggregated data, the number of people within each subgroup.
This must be available for all subgroups.}

\item{weight}{The individual sampling weight, for individual-level data from
a survey. This must be available for all individuals.}

\item{psu}{Primary sampling unit, for individual-level data from a survey.}

\item{strata}{Strata, for individual-level data from a survey.}

\item{fpc}{Finite population correction, for individual-level data from a
survey where sample size is large relative to population size.}

\item{lmin}{Minimum limit for bounded indicators
(i.e., variables that have a finite upper and/or lower limit).}

\item{lmax}{Maximum limit for bounded indicators
(i.e., variables that have a finite upper and/or lower limit).}

\item{conf.level}{Confidence level of the interval. Default is 0.95 (95\%).}

\item{force}{TRUE/FALSE statement to force calculation with missing
indicator estimate values.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The estimated ACI value, corresponding estimated standard error,
and confidence interval as a \code{data.frame}.
}
\description{
The absolute concentration index (ACI) is an absolute measure of inequality
that indicates the extent to which an indicator is concentrated among
disadvantaged or advantaged subgroups, on an absolute scale.
}
\details{
ACI can be calculated using disaggregated data and individual-level data.
Subgroups in disaggregated data are weighted according to their population
share, while individuals are weighted by sample weight in the case of data
from surveys.

The calculation of ACI is based on a ranking of the whole population from
the most disadvantaged subgroup (at rank 0) to the most advantaged subgroup
(at rank 1), which is inferred from the ranking and size of the subgroups.
ACI can be calculated as twice the covariance between the health indicator
and the relative rank. Given the relationship between covariance and
ordinary least squares regression, ACI can be obtained from a
regression of a transformation of the health variable of interest on the
relative rank. For more information on this inequality measure see
Schlotheuber (2022) below.

\strong{Interpretation:} ACI is 0 if there is no inequality. The larger the
absolute value of ACI, the higher the level of inequality. Positive values
indicate a concentration of the indicator among advantaged subgroups, and
negative values indicate a concentration of the indicator among
disadvantaged subgroups.

\strong{Type of summary measure:} Complex; absolute; weighted

\strong{Applicability:} Ordered dimension of inequality with more than two
subgroups

\strong{Warning:} The confidence intervals are approximate and might be biased.
}
\examples{
# example code
data(IndividualSample)
head(IndividualSample)
with(IndividualSample,
     aci(est = sba,
         subgroup_order = subgroup_order,
         weight = weight,
         psu = psu,
         strata = strata))
# example code
data(OrderedSample)
head(OrderedSample)
with(OrderedSample,
     aci(est = estimate,
         subgroup_order = subgroup_order,
         pop = population))
}
\references{
Schlotheuber, A, Hosseinpoor, AR. Summary measures of health
inequality: A review of existing measures and their application. Int J
Environ Res Public Health. 2022;19(6):3697. doi:10.3390/ijerph19063697.
}
