% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt-diverging-bar.R
\name{diverging_bar_plt}
\alias{diverging_bar_plt}
\title{Diverging Bar Chart}
\usage{
diverging_bar_plt(
  .data,
  .x_axis,
  .y_axis,
  .fill_col,
  .plot_title = NULL,
  .plot_subtitle = NULL,
  .plot_caption = NULL,
  .interactive = FALSE
)
}
\arguments{
\item{.data}{The data to pass to the function, must be a tibble/data.frame.}

\item{.x_axis}{The data that is passed to the x-axis.}

\item{.y_axis}{The data that is passed to the y-axis. This will also equal the
parameter \code{label}}

\item{.fill_col}{The column that will be used to fill the color of the bars.}

\item{.plot_title}{Default is NULL}

\item{.plot_subtitle}{Default is NULL}

\item{.plot_caption}{Default is NULL}

\item{.interactive}{Default is FALSE. TRUE returns a plotly plot}
}
\value{
A \code{plotly} plot or a \code{ggplot2} static plot
}
\description{
Diverging Bars is a bar chart that can handle both negative and positive
values. This can be implemented by a smart tweak with \code{geom_bar()}. But the
usage of \code{geom_bar()} can be quite confusing. That's because, it can be used to
make a bar chart as well as a histogram. Let me explain.

By default, \code{geom_bar()} has the stat set to count. That means, when you
provide just a continuous X variable (and no Y variable), it tries to make
a histogram out of the data.

In order to make a bar chart create bars instead of histogram,
you need to do two things. Set \code{stat = identity} and provide both \code{x} and \code{y}
inside \code{aes()} where, \code{x} is either character or factor and \code{y} is numeric.
In order to make sure you get diverging bars instead of just bars, make sure,
your categorical variable has 2 categories that changes values at a certain
threshold of the continuous variable. In below example, the mpg from mtcars
data set is normalized by computing the z score. Those vehicles with mpg
above zero are marked green and those below are marked red.
}
\details{
This function takes only a few arguments and returns a ggplot2 object.
}
\examples{
suppressPackageStartupMessages(library(ggplot2))

data("mtcars")
mtcars$car_name <- rownames(mtcars)
mtcars$mpg_z <- round((mtcars$mpg - mean(mtcars$mpg))/sd(mtcars$mpg), 2)
mtcars$mpg_type <- ifelse(mtcars$mpg_z < 0, "below", "above")
mtcars <- mtcars[order(mtcars$mpg_z), ]  # sort
mtcars$car_name <- factor(mtcars$car_name, levels = mtcars$car_name)

diverging_bar_plt(
  .data          = mtcars
  , .x_axis      = car_name
  , .y_axis      = mpg_z
  , .fill_col    = mpg_type
  , .interactive = FALSE
)

}
\seealso{
Other Plotting Functions: 
\code{\link{diverging_lollipop_plt}()},
\code{\link{gartner_magic_chart_plt}()},
\code{\link{los_ra_index_plt}()},
\code{\link{ts_alos_plt}()},
\code{\link{ts_median_excess_plt}()},
\code{\link{ts_plt}()},
\code{\link{ts_readmit_rate_plt}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Plotting Functions}
