% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt-diverging-lollipop.R
\name{diverging_lollipop_plt}
\alias{diverging_lollipop_plt}
\title{Diverging Lollipop Chart}
\usage{
diverging_lollipop_plt(
  .data,
  .x_axis,
  .y_axis,
  .plot_title = NULL,
  .plot_subtitle = NULL,
  .plot_caption = NULL,
  .interactive = FALSE
)
}
\arguments{
\item{.data}{The data to pass to the function, must be a tibble/data.frame.}

\item{.x_axis}{The data that is passed to the x-axis. This will also be the
\code{x} and \code{xend} parameters of the \code{geom_segment}}

\item{.y_axis}{The data that is passed to the y-axis. This will also equal the
parameters of \code{yend} and \code{label}}

\item{.plot_title}{Default is NULL}

\item{.plot_subtitle}{Default is NULL}

\item{.plot_caption}{Default is NULL}

\item{.interactive}{Default is FALSE. TRUE returns a plotly plot}
}
\value{
A \code{plotly} plot or a \code{ggplot2} static plot
}
\description{
This is a diverging lollipop function. Lollipop chart conveys the same
information as bar chart and diverging bar. Except that it looks more modern.
Instead of geom_bar, I use geom_point and geom_segment to get the lollipops
right. Let’s draw a lollipop using the same data I prepared in the previous
example of diverging bars.
}
\details{
This function takes only a few arguments and returns a ggplot2 object.
}
\examples{
suppressPackageStartupMessages(library(ggplot2))

data("mtcars")
mtcars$car_name <- rownames(mtcars)
mtcars$mpg_z <- round((mtcars$mpg - mean(mtcars$mpg))/sd(mtcars$mpg), 2)
mtcars$mpg_type <- ifelse(mtcars$mpg_z < 0, "below", "above")
mtcars <- mtcars[order(mtcars$mpg_z), ]  # sort
mtcars$car_name <- factor(mtcars$car_name, levels = mtcars$car_name)

diverging_lollipop_plt(.data = mtcars, .x_axis = car_name
, .y_axis = mpg_z)

}
\seealso{
Other Plotting Functions: 
\code{\link{diverging_bar_plt}()},
\code{\link{gartner_magic_chart_plt}()},
\code{\link{los_ra_index_plt}()},
\code{\link{ts_alos_plt}()},
\code{\link{ts_median_excess_plt}()},
\code{\link{ts_plt}()},
\code{\link{ts_readmit_rate_plt}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Plotting Functions}
