% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_pattern.R
\name{extract_pattern}
\alias{extract_pattern}
\title{Extract patterns from larger documents}
\usage{
extract_pattern(filepath, keyword, preserve = FALSE)
}
\arguments{
\item{filepath}{A valid character string to the plaintext file containing
the pattern.}

\item{keyword}{A placeholder which signposts the beginning and end of the
pattern to be extracted.}

\item{preserve}{A boolean (\code{TRUE/FALSE}) value indicating whether or not
keywords should be included in the extracted pattern (\code{TRUE}) or not
(\code{FALSE}); default \code{FALSE}.}
}
\value{
A character string, typically used to assemble a draft.
}
\description{
This function loads a file and scans it for a given keyword which signposts
the beginning and end of a pattern. It then extracts all the text between the
keywords for manipulation as a pattern. For extracting multiple patterns at
once from a single file, check out \code{\link[heddlr]{extract_draft}}.
}
\examples{
pattern_file <- tempfile("out", tempdir(), ".Rmd")
export_template("EXTRACT my sample pattern EXTRACT", pattern_file)
extract_pattern(pattern_file, "EXTRACT")
}
\seealso{
Other import functions: 
\code{\link{extract_draft}()},
\code{\link{import_draft}()},
\code{\link{import_pattern}()}
}
\concept{import functions}
