% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhance.grid.R
\name{enhance.grid}
\alias{enhance.grid}
\title{Enhance penalty value using grid search}
\usage{
enhance.grid(obj, par, prepare = TRUE, loggcv = FALSE, ..., cl = NULL)
}
\arguments{
\item{obj}{A \code{prepared_*} object from a
\code{\link{prepare}} function.}

\item{par}{A matrix-like object (i.e.,
\code{!is.null(dim(par)))}).  Each row contains a set
of parameter values for which the GCV statistic should
be computed.  The number of columns of \code{par}
should match the dimensionality of \code{obj}, i.e,
should equal \code{length(obj)$n}.  If missing, the
default choices are a row of -20s, a row of 0s, and a
row of 20s.}

\item{prepare}{A logical value.  The default is \code{TRUE},
indicating that a \code{prepared_data} object should be
returned.  If \code{FALSE}, then the results of the
call to the \code{\link[optimx]{optimx}} function is
returned.}

\item{loggcv}{A logical value indicating whether the log
of the GCV statistic should be used.  Useful for very large
data sets.  Default is \code{TRUE}.}

\item{...}{Additional arguments to pass to to the
\code{\link{loglambda2gcv}} function.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
It can also be \code{"future"} to use a future backend (see Details),
\code{NULL} (default) refers to sequential evaluation.
}
}
\value{
By default, a \code{prepared_*} object with the
  optimal \code{loglambda} values that minimize the GCV,
  along with an additional component, \code{results},
  that contains the optimization results. Otherwise, the
  complete results of the grid search.
}
\description{
\code{enhance.grid} enhances the sandwich smoother by
choosing a optimal penalty value to lower the GCV
statistic.  A grid search algorithm is utilized based on
the each row of \code{par}.  The penalty values (assumed
to be on the log scale) are passed to the
\code{\link{loglambda2gcv}} function.  If \code{prepare}
is \code{TRUE}, then \code{obj} is returned with the
penalty values that minimize the GCV statistic during the
grid search.  Otherwise, the complete results of the grid
search are returned.
}
\examples{
# create b-splines
b1 = bspline(nbasis = 10)
b2 = bspline(nbasis = 12)

# observed data locations
x1 = seq(0, 1, len = 60)
x2 = seq(0, 1, len = 80)

# construct "true" data
mu = matrix(0, nrow = 60, ncol = 80)
for(i in seq_len(60)) {
   for(j in seq_len(80)) {
      mu[i, j] =  sin(2*pi*(x1[i]-.5)^3)*cos(4*pi*x2[j])
   }
}
# construct noisy data
data = mu + rnorm(60 * 80)

obj = prepare(data, list(x1, x2), list(b1, b2))
enhance.grid(obj, prepare = FALSE)
}
\author{
Joshua French
}
