% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invisible.R
\name{gwpca_core}
\alias{gwpca_core}
\title{Core Function of GWPCA}
\usage{
gwpca_core(xy, p_xy, env, env_trans, tau)
}
\arguments{
\item{xy}{A matrix containing the coordinates of the points where environmental measurements were taken. The matrix should have two columns, representing the X and Y coordinates.}

\item{p_xy}{A matrix containing the coordinates of the point GWPCA will be estimated. It should have two columns for X and Y coordinates.}

\item{env}{A data matrix representing the environmental variables. Rows represent observations (points or grid cells), and columns represent environmental variables.}

\item{env_trans}{Transpose of \code{env} matrix.}

\item{tau}{The bandwidth parameter for spatial weighting in GWPCA. It determines the extent of spatial influence on the estimation of principal components.}
}
\value{
A vector of eigenvalues from local PCA
}
\description{
The \code{gwpca_core} function is a core implementation of Generalized Weighted Principal Component Analysis for each iteration.
}
