% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{SKK_sim}
\alias{SKK_sim}
\title{Apply the SKK test to multiple simulated two-sample datasets}
\usage{
SKK_sim(DATA)
}
\arguments{
\item{DATA}{The list of dataset lists generated by \code{buildData}.}
}
\value{
a dataframe, each row of which reports the values of the
SKK test statistics and the p-values.
}
\description{
This function performs the SKK test of Srivastava, Katayama, and Kano(2013) on multiple high-dimensional two-sample datasets.
It is useful for Monte Carlo experiments.
}
\examples{
# Generate 3 simulated datasets and apply the SKK test
data <- buildData(n = 45, m =60, p = 300,
                 muX = rep(0,300), muY = rep(0,300),
                 dep = 'IND', S = 3, innov = rnorm)
SKK_sim(data)


}
\references{
Srivastava, M. S., Katayama, S., and Kano, Y. (2013).
A two sample test in high dimensional data. Journal of Multivariate Analysis, 114:349-358.
}
