% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{zwl_sim}
\alias{zwl_sim}
\title{Apply the test by Zhang and Wang (2020) to multiple simulated two-sample datasets}
\usage{
zwl_sim(DATA, order = 0)
}
\arguments{
\item{DATA}{The list of dataset lists generated by \code{buildData}.}

\item{order}{The order of the center correction. Possible choices are 0, 2.
To use the ZWLm test, set \code{order = 0}; to use the ZWL test, set \code{order = 2}. THE ZWLm test is recommended for moderate sample sizes.}
}
\value{
A dataframe with each row consisting the values of the
test statistics, p-values, Tn, and the estimate of Var(Tn).
}
\description{
Apply the two-sample high-dimensional test by Zhang and Wang (2020) to multiple simulated two-sample high dimensional datasets. This function is useful for Monte Carlo experiments.
}
\examples{
# Generate 3 simulated two-sample datasets and apply the ZWL test
data <- buildData(n = 45, m =60, p = 300,
          muX = rep(0,300), muY = rep(0,300),
          dep = 'IND', S = 3, innov = rnorm)
zwl_sim(data, order = 2)


}
\references{
Zhang, H. and Wang, H. (2020). Result consistency of high dimensional
two-sample tests applied to gene ontology terms with gene sets. Manuscript in review.
}
